/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.ser.GraphBinaryMessageSerializerV4;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public final class Settings {
    public int port = 8182;
    public String path = "/gremlin";
    public List<String> hosts = new ArrayList<String>();
    public SerializerSettings serializer = new SerializerSettings();
    public ConnectionPoolSettings connectionPool = new ConnectionPoolSettings();
    public AuthSettings auth = new AuthSettings();
    public int nioPoolSize = Runtime.getRuntime().availableProcessors();
    public int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    public boolean enableUserAgentOnConnect = true;
    public boolean bulkResults = false;

    public static Settings read(InputStream stream) {
        Objects.requireNonNull(stream);
        LoaderOptions options = new LoaderOptions();
        Constructor constructor = new Constructor(Settings.class, options);
        TypeDescription settingsDescription = new TypeDescription(Settings.class);
        settingsDescription.addPropertyParameters("hosts", new Class[]{String.class});
        settingsDescription.addPropertyParameters("serializer", new Class[]{SerializerSettings.class});
        constructor.addTypeDescription(settingsDescription);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        return (Settings)yaml.loadAs(stream, Settings.class);
    }

    public static Settings from(Configuration conf) {
        Configuration authConf;
        Configuration connectionPoolConf;
        Settings settings = new Settings();
        if (conf.containsKey("port")) {
            settings.port = conf.getInt("port");
        }
        if (conf.containsKey("nioPoolSize")) {
            settings.nioPoolSize = conf.getInt("nioPoolSize");
        }
        if (conf.containsKey("workerPoolSize")) {
            settings.workerPoolSize = conf.getInt("workerPoolSize");
        }
        if (conf.containsKey("enableUserAgentOnConnect")) {
            settings.enableUserAgentOnConnect = conf.getBoolean("enableUserAgentOnConnect");
        }
        if (conf.containsKey("bulkResults")) {
            settings.bulkResults = conf.getBoolean("bulkResults");
        }
        if (conf.containsKey("hosts")) {
            settings.hosts = conf.getList("hosts").stream().map(Object::toString).collect(Collectors.toList());
        }
        if (conf.containsKey("serializer.className")) {
            Configuration serializerConfigConf;
            SerializerSettings serializerSettings = new SerializerSettings();
            Configuration serializerConf = conf.subset("serializer");
            if (serializerConf.containsKey("className")) {
                serializerSettings.className = serializerConf.getString("className");
            }
            if (IteratorUtils.count((Iterator)(serializerConfigConf = conf.subset("serializer.config")).getKeys()) > 0L) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                serializerConfigConf.getKeys().forEachRemaining(name -> m.put((String)name, serializerConfigConf.getProperty(name)));
                serializerSettings.config = m;
            }
            settings.serializer = serializerSettings;
        }
        if (IteratorUtils.count((Iterator)(connectionPoolConf = conf.subset("connectionPool")).getKeys()) > 0L) {
            ConnectionPoolSettings cpSettings = new ConnectionPoolSettings();
            if (connectionPoolConf.containsKey("enableSsl")) {
                cpSettings.enableSsl = connectionPoolConf.getBoolean("enableSsl");
            }
            if (connectionPoolConf.containsKey("keyStore")) {
                cpSettings.keyStore = connectionPoolConf.getString("keyStore");
            }
            if (connectionPoolConf.containsKey("keyStorePassword")) {
                cpSettings.keyStorePassword = connectionPoolConf.getString("keyStorePassword");
            }
            if (connectionPoolConf.containsKey("keyStoreType")) {
                cpSettings.keyStoreType = connectionPoolConf.getString("keyStoreType");
            }
            if (connectionPoolConf.containsKey("trustStore")) {
                cpSettings.trustStore = connectionPoolConf.getString("trustStore");
            }
            if (connectionPoolConf.containsKey("trustStorePassword")) {
                cpSettings.trustStorePassword = connectionPoolConf.getString("trustStorePassword");
            }
            if (connectionPoolConf.containsKey("trustStoreType")) {
                cpSettings.trustStoreType = connectionPoolConf.getString("trustStoreType");
            }
            if (connectionPoolConf.containsKey("sslEnabledProtocols")) {
                cpSettings.sslEnabledProtocols = connectionPoolConf.getList("sslEnabledProtocols").stream().map(Object::toString).collect(Collectors.toList());
            }
            if (connectionPoolConf.containsKey("sslCipherSuites")) {
                cpSettings.sslCipherSuites = connectionPoolConf.getList("sslCipherSuites").stream().map(Object::toString).collect(Collectors.toList());
            }
            if (connectionPoolConf.containsKey("sslSkipCertValidation")) {
                cpSettings.sslSkipCertValidation = connectionPoolConf.getBoolean("sslSkipCertValidation");
            }
            if (connectionPoolConf.containsKey("maxSize")) {
                cpSettings.maxSize = connectionPoolConf.getInt("maxSize");
            }
            if (connectionPoolConf.containsKey("maxWaitForConnection")) {
                cpSettings.maxWaitForConnection = connectionPoolConf.getInt("maxWaitForConnection");
            }
            if (connectionPoolConf.containsKey("maxWaitForClose")) {
                cpSettings.maxWaitForClose = connectionPoolConf.getInt("maxWaitForClose");
            }
            if (connectionPoolConf.containsKey("maxResponseContentLength")) {
                cpSettings.maxResponseContentLength = connectionPoolConf.getInt("maxResponseContentLength");
            }
            if (connectionPoolConf.containsKey("reconnectInterval")) {
                cpSettings.reconnectInterval = connectionPoolConf.getInt("reconnectInterval");
            }
            if (connectionPoolConf.containsKey("resultIterationBatchSize")) {
                cpSettings.resultIterationBatchSize = connectionPoolConf.getInt("resultIterationBatchSize");
            }
            if (connectionPoolConf.containsKey("validationRequest")) {
                cpSettings.validationRequest = connectionPoolConf.getString("validationRequest");
            }
            if (connectionPoolConf.containsKey("connectionSetupTimeoutMillis")) {
                cpSettings.connectionSetupTimeoutMillis = connectionPoolConf.getLong("connectionSetupTimeoutMillis");
            }
            if (connectionPoolConf.containsKey("idleConnectionTimeout")) {
                cpSettings.idleConnectionTimeout = connectionPoolConf.getLong("idleConnectionTimeout");
            }
            settings.connectionPool = cpSettings;
        }
        if (IteratorUtils.count((Iterator)(authConf = conf.subset("auth")).getKeys()) > 0L) {
            AuthSettings authSettings = new AuthSettings();
            if (authConf.containsKey("type")) {
                authSettings.type = authConf.getString("type");
            }
            if (authConf.containsKey("username")) {
                authSettings.username = authConf.getString("username");
            }
            if (authConf.containsKey("password")) {
                authSettings.password = authConf.getString("password");
            }
            settings.auth = authSettings;
        }
        return settings;
    }

    public static class AuthSettings {
        public String type = "";
        public String username = null;
        public String password = null;
        public String region = null;
        public String serviceName = null;
    }

    public static class SerializerSettings {
        public String className = GraphBinaryMessageSerializerV4.class.getCanonicalName();
        public Map<String, Object> config = null;

        public MessageSerializer<?> create() throws Exception {
            Class<?> clazz = Class.forName(this.className);
            MessageSerializer serializer = (MessageSerializer)clazz.newInstance();
            Optional.ofNullable(this.config).ifPresent(c -> serializer.configure(c, null));
            return serializer;
        }
    }

    static class ConnectionPoolSettings {
        public boolean enableSsl = false;
        public String keyStore;
        public String keyStorePassword;
        public String trustStore;
        public String trustStorePassword;
        public String keyStoreType;
        public String trustStoreType;
        public List<String> sslEnabledProtocols = new ArrayList<String>();
        public List<String> sslCipherSuites = new ArrayList<String>();
        public boolean sslSkipCertValidation = false;
        public int maxSize = 128;
        public int maxWaitForConnection = 16000;
        public int maxWaitForClose = 3000;
        public long maxResponseContentLength = Integer.MAX_VALUE;
        public int reconnectInterval = 1000;
        public int resultIterationBatchSize = 64;
        public String validationRequest = "g.inject(0)";
        public long connectionSetupTimeoutMillis = 15000L;
        public long idleConnectionTimeout = 180000L;

        ConnectionPoolSettings() {
        }
    }
}

