/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.auth;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.HttpRequest;
import org.apache.tinkerpop.gremlin.driver.auth.Auth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class Sigv4
implements Auth {
    private static final Logger logger = LoggerFactory.getLogger(Sigv4.class);
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final AwsV4HttpSigner aws4Signer;
    private final String serviceName;
    private final String regionName;

    public Sigv4(String regionName, String serviceName) {
        this(regionName, (AwsCredentialsProvider)DefaultCredentialsProvider.create(), serviceName);
    }

    public Sigv4(String regionName, AwsCredentialsProvider awsCredentialsProvider, String serviceName) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.aws4Signer = AwsV4HttpSigner.create();
        this.regionName = regionName;
        this.serviceName = serviceName;
    }

    @Override
    public HttpRequest apply(HttpRequest httpRequest) {
        try {
            ContentStreamProvider content = this.toContentStream(httpRequest);
            SdkHttpRequest awsSignableRequest = this.toSignableRequest(httpRequest);
            AwsCredentials credentials = this.awsCredentialsProvider.resolveCredentials();
            SignedRequest signed = this.aws4Signer.sign(r -> ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)r.identity((Identity)credentials)).request(awsSignableRequest)).payload((Object)content)).putProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)this.serviceName)).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this.regionName));
            Map<String, String> headers = httpRequest.headers();
            this.setSignedHeaders(headers, signed);
            this.setSessionToken(headers, credentials);
        }
        catch (Exception ex) {
            logger.error("Error signing HTTP request: {}", (Object)ex.getMessage(), (Object)ex);
            throw new Auth.AuthenticationException(ex);
        }
        return httpRequest;
    }

    private void setSessionToken(Map<String, String> headers, AwsCredentials credentials) {
        String sessionToken;
        if (credentials instanceof AwsSessionCredentials && (sessionToken = ((AwsSessionCredentials)credentials).sessionToken()) != null && !sessionToken.isEmpty()) {
            headers.put("X-Amz-Security-Token", sessionToken);
        }
    }

    private void setSignedHeaders(Map<String, String> headers, SignedRequest signed) {
        headers.remove("host");
        headers.put("Host", signed.request().host());
        Map signedHeaders = signed.request().headers();
        headers.put("X-Amz-Date", this.getSingleHeaderValue(signedHeaders, "X-Amz-Date"));
        headers.put("Authorization", this.getSingleHeaderValue(signedHeaders, "Authorization"));
        headers.put("x-amz-content-sha256", this.getSingleHeaderValue(signedHeaders, "x-amz-content-sha256"));
    }

    private String getSingleHeaderValue(Map<String, List<String>> headers, String headerName) {
        HashSet headerValues = new HashSet(headers.containsKey(headerName) ? (Collection)headers.get(headerName) : Collections.emptySet());
        if (headerValues.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected 1 header %s but found %d", headerName, headerValues.size()));
        }
        return (String)headerValues.iterator().next();
    }

    private ContentStreamProvider toContentStream(HttpRequest httpRequest) {
        if (!(httpRequest.getBody() instanceof byte[])) {
            throw new IllegalArgumentException("Expected byte[] in HttpRequest body but got " + httpRequest.getBody().getClass());
        }
        byte[] body = (byte[])httpRequest.getBody();
        return body.length != 0 ? ContentStreamProvider.fromByteArray((byte[])body) : ContentStreamProvider.fromUtf8String((String)"");
    }

    private SdkHttpRequest toSignableRequest(HttpRequest request) {
        this.checkNotNull(request.getUri(), "The request URI must not be null");
        this.checkNotNull(request.getMethod(), "The request method must not be null");
        Map<String, String> headers = request.headers();
        HashMap<String, List<String>> headersInternal = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            if (header.getKey().equalsIgnoreCase("host")) continue;
            headersInternal.put(header.getKey(), Collections.singletonList(header.getValue()));
        }
        URI uri = request.getUri();
        HashMap<String, List<String>> parametersInternal = this.extractParametersFromQueryString(uri.getQuery());
        URI endpointUri = URI.create(uri.getScheme() + "://" + uri.getHost());
        return (SdkHttpRequest)SdkHttpRequest.builder().uri(endpointUri).encodedPath(uri.getPath()).method(SdkHttpMethod.fromValue((String)request.getMethod())).headers(headersInternal).rawQueryParameters(parametersInternal).build();
    }

    private HashMap<String, List<String>> extractParametersFromQueryString(String queryStr) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (queryStr == null) {
            return parameters;
        }
        for (String queryParam : queryStr.split("&")) {
            if (queryParam.isEmpty()) continue;
            String[] keyValuePair = queryParam.split("=", 2);
            String key = SdkHttpUtils.urlDecode((String)keyValuePair[0]);
            String value = keyValuePair.length == 2 ? SdkHttpUtils.urlDecode((String)keyValuePair[1]) : "";
            if (!parameters.containsKey(key)) {
                parameters.put(key, new ArrayList());
            }
            parameters.get(key).add(value);
        }
        return parameters;
    }

    private void checkNotNull(Object obj, String errMsg) {
        if (obj == null) {
            throw new IllegalArgumentException(errMsg);
        }
    }
}

