/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.driver.HttpRequest;
import org.apache.tinkerpop.gremlin.driver.RequestInterceptor;
import org.apache.tinkerpop.gremlin.driver.UserAgent;
import org.apache.tinkerpop.gremlin.driver.auth.Auth;
import org.apache.tinkerpop.gremlin.driver.exception.ResponseException;
import org.apache.tinkerpop.gremlin.driver.handler.GremlinResponseHandler;
import org.apache.tinkerpop.gremlin.driver.handler.InactiveChannelHandler;
import org.apache.tinkerpop.gremlin.process.traversal.GremlinLang;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;

@ChannelHandler.Sharable
public final class HttpGremlinRequestEncoder
extends MessageToMessageEncoder<RequestMessage> {
    private final MessageSerializer<?> serializer;
    private final boolean userAgentEnabled;
    private final boolean bulkResults;
    private final List<Pair<String, ? extends RequestInterceptor>> interceptors;
    private final URI uri;

    public HttpGremlinRequestEncoder(MessageSerializer<?> serializer, List<Pair<String, ? extends RequestInterceptor>> interceptors, boolean userAgentEnabled, boolean bulkResults, URI uri) {
        this.serializer = serializer;
        this.interceptors = interceptors;
        this.userAgentEnabled = userAgentEnabled;
        this.bulkResults = bulkResults;
        this.uri = uri;
    }

    protected void encode(ChannelHandlerContext channelHandlerContext, RequestMessage requestMessage, List<Object> objects) throws Exception {
        String mimeType = this.serializer.mimeTypesSupported()[0];
        if (requestMessage.getField("gremlin") instanceof GremlinLang) {
            throw new ResponseException(HttpResponseStatus.BAD_REQUEST, String.format("An error occurred during serialization of this request [%s] - it could not be sent to the server - Reason: GremlinLang is not intended to be send as query.", requestMessage));
        }
        InetSocketAddress remoteAddress = HttpGremlinRequestEncoder.getRemoteAddress(channelHandlerContext.channel());
        try {
            HashMap<String, String> headersMap = new HashMap<String, String>();
            headersMap.put("host", remoteAddress.getAddress().getHostAddress());
            headersMap.put("accept", mimeType);
            headersMap.put("accept-encoding", "deflate");
            if (this.userAgentEnabled) {
                headersMap.put("user-agent", UserAgent.USER_AGENT);
            }
            if (this.bulkResults) {
                headersMap.put("bulkResults", "true");
            }
            HttpRequest gremlinRequest = new HttpRequest(headersMap, requestMessage, this.uri);
            for (Pair<String, ? extends RequestInterceptor> interceptor : this.interceptors) {
                gremlinRequest = (HttpRequest)((RequestInterceptor)interceptor.getRight()).apply(gremlinRequest);
            }
            DefaultFullHttpRequest finalRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.uri.getPath(), HttpGremlinRequestEncoder.convertBody(gremlinRequest));
            gremlinRequest.headers().forEach((arg_0, arg_1) -> HttpGremlinRequestEncoder.lambda$encode$0((FullHttpRequest)finalRequest, arg_0, arg_1));
            objects.add(finalRequest);
            channelHandlerContext.channel().attr(InactiveChannelHandler.REQUEST_SENT).set((Object)true);
        }
        catch (Auth.AuthenticationException ex) {
            throw new ResponseException(HttpResponseStatus.BAD_REQUEST, String.format("An error occurred during authentication [%s] - it could not be sent to the server - Reason: %s", requestMessage, ex));
        }
    }

    private static InetSocketAddress getRemoteAddress(Channel channel) {
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        if (remoteAddress == null) {
            Throwable sslException = (Throwable)channel.attr(GremlinResponseHandler.INBOUND_SSL_EXCEPTION).get();
            if (sslException != null) {
                throw new RuntimeException("Request cannot be serialized because the channel is not connected due to an ssl error.", sslException);
            }
            throw new RuntimeException("Request cannot be serialized because the channel is not connected");
        }
        return remoteAddress;
    }

    private static ByteBuf convertBody(HttpRequest request) {
        Object body = request.getBody();
        if (body instanceof byte[]) {
            request.headers().put("content-length", String.valueOf(((byte[])body).length));
            return Unpooled.wrappedBuffer((byte[])((byte[])body));
        }
        throw new IllegalArgumentException("Final body must be byte[] but found " + body.getClass().getSimpleName());
    }

    private static /* synthetic */ void lambda$encode$0(FullHttpRequest finalRequest, String k, String v) {
        finalRequest.headers().add(k, (Object)v);
    }
}

