/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import org.apache.tinkerpop.gremlin.driver.handler.IdleConnectionHandler;

@ChannelHandler.Sharable
public class InactiveChannelHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<Integer> BYTES_READ = AttributeKey.valueOf((String)"bytesRead");
    public static final AttributeKey<Boolean> REQUEST_SENT = AttributeKey.valueOf((String)"requestSent");

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (null == ctx.channel().attr(BYTES_READ).get() && null != ctx.channel().attr(REQUEST_SENT).get()) {
            String errMsg = ctx.channel().hasAttr(IdleConnectionHandler.IDLE_STATE_EVENT) ? "Idle timeout occurred before response could be received from server - consider increasing idleConnectionTimeout" : "Connection to server closed unexpectedly. Ensure that the server is still reachable. The server may be expecting SSL to be enabled.";
            ctx.fireExceptionCaught((Throwable)new RuntimeException(errMsg));
        } else {
            super.channelInactive(ctx);
        }
    }
}

