/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet;

import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messagelet.ConsumerThread;
import org.apache.commons.messagelet.MessageDrivenObject;
import org.apache.commons.messagelet.MessengerMDO;
import org.apache.commons.messagelet.model.Subscription;
import org.apache.commons.messagelet.model.SubscriptionList;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;
import org.apache.commons.messenger.tool.StopWatchMessageListener;

public class SubscriptionManager {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messagelet$SubscriptionManager == null ? (class$org$apache$commons$messagelet$SubscriptionManager = SubscriptionManager.class$("org.apache.commons.messagelet.SubscriptionManager")) : class$org$apache$commons$messagelet$SubscriptionManager));
    private MessengerManager manager;
    private SubscriptionList subscriptionList;
    private ServletContext servletContext;
    private boolean useStopWatch = false;
    static /* synthetic */ Class class$org$apache$commons$messagelet$SubscriptionManager;

    protected void subscribe() throws JMSException, ServletException {
        Iterator iter = this.getSubscriptionList().getSubscriptions().iterator();
        while (iter.hasNext()) {
            Subscription subscription = (Subscription)iter.next();
            this.subscribe(subscription);
        }
    }

    public void subscribe(Subscription subscription) throws JMSException, ServletException {
        String name = subscription.getConnection();
        Messenger messenger = this.getMessenger(name);
        if (messenger == null) {
            throw new JMSException("No such Messenger called: " + name + " for subscription: " + subscription);
        }
        String subject = subscription.getSubject();
        if (subject == null || subject.length() == 0) {
            throw new JMSException("No destination defined for subscription: " + subscription);
        }
        Destination destination = messenger.getDestination(subject);
        if (destination == null) {
            throw new JMSException("No destination could be found for name: " + subject + " for subscription: " + subscription);
        }
        MessageListener listener = subscription.getMessageListener();
        if (listener == null) {
            throw new JMSException("No MessageListener is defined for subscription: " + subscription);
        }
        if (listener instanceof MessageDrivenObject) {
            MessageDrivenObject mdo = (MessageDrivenObject)listener;
            if (mdo instanceof MessengerMDO) {
                MessengerMDO messengerMDO = (MessengerMDO)mdo;
                messengerMDO.setMessenger(messenger);
                messengerMDO.setMessengerManager(this.getMessengerManager());
            }
            mdo.init(this.getServletContext());
        }
        listener = this.wrapInStopWatch(listener);
        String selector = subscription.getSelector();
        ConsumerThread thread = subscription.getConsumerThread();
        if (thread != null) {
            log.info((Object)("Subscribing to messenger: " + name + " destination: " + subject + " selector: " + selector + " with: " + thread));
            thread.setMessenger(messenger);
            thread.setDestination(destination);
            thread.setSelector(selector);
            thread.setListener(listener);
            thread.start();
        } else {
            if (selector != null && selector.length() > 0) {
                log.info((Object)("Subscribing to messenger: " + name + " destination: " + subject + " selector: " + selector));
                messenger.addListener(destination, selector, listener);
            } else {
                log.info((Object)("Subscribing to messenger: " + name + " destination: " + subject));
                messenger.addListener(destination, listener);
            }
            log.info((Object)("Subscribed with listener: " + listener));
        }
    }

    public void unsubscribe() throws JMSException, ServletException {
        SubscriptionList list = this.getSubscriptionList();
        if (list != null) {
            Iterator iter = list.getSubscriptions().iterator();
            while (iter.hasNext()) {
                Subscription subscription = (Subscription)iter.next();
                this.unsubscribe(subscription);
            }
        }
    }

    public void unsubscribe(Subscription subscription) throws JMSException, ServletException {
        String name = subscription.getConnection();
        Messenger messenger = this.getMessenger(name);
        MessageListener listener = subscription.getMessageListener();
        if (messenger != null && listener != null) {
            Destination destination = null;
            String subject = subscription.getSubject();
            if (subject == null || subject.length() == 0) {
                log.error((Object)("No destination defined for subscription: " + subscription));
            } else {
                try {
                    destination = messenger.getDestination(subject);
                    if (destination == null) {
                        log.error((Object)("No destination could be found for name: " + subject + " for subscription: " + subscription));
                    }
                }
                catch (JMSException e) {
                    log.error((Object)("Could not create destination for name: " + subject + " for subscription: " + subscription), (Throwable)e);
                }
            }
            if (destination != null) {
                try {
                    String selector = subscription.getSelector();
                    if (selector != null && selector.length() > 0) {
                        messenger.removeListener(destination, selector, listener);
                    } else {
                        messenger.removeListener(destination, listener);
                    }
                }
                catch (JMSException e) {
                    log.error((Object)("Could not unsubscribe to destination:" + destination + " for subscription: " + subscription), (Throwable)e);
                }
            }
        }
        if (listener instanceof MessageDrivenObject) {
            MessageDrivenObject mdo = (MessageDrivenObject)listener;
            mdo.destroy();
        }
    }

    public MessengerManager getMessengerManager() throws JMSException {
        return this.manager;
    }

    public void setMessengerManager(MessengerManager manager) {
        this.manager = manager;
    }

    public SubscriptionList getSubscriptionList() {
        return this.subscriptionList;
    }

    public void setSubscriptionList(SubscriptionList subscriptionList) {
        this.subscriptionList = subscriptionList;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected MessageListener wrapInStopWatch(MessageListener listener) {
        if (this.useStopWatch) {
            return new StopWatchMessageListener(listener);
        }
        return listener;
    }

    protected Messenger getMessenger(String name) throws JMSException {
        return this.getMessengerManager().getMessenger(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

