/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.locking;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryFactory;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.locking.LockEntry;
import ojb.odmg.locking.LockStrategy;
import ojb.odmg.locking.LockStrategyFactory;

public abstract class AbstractLockStrategy
implements LockStrategy {
    public static long DEFAULT_LOCK_TIMEOUT = 30000L;
    static /* synthetic */ Class class$ojb$odmg$locking$LockEntry;

    private void unCache(LockEntry entry) {
        if (entry != null) {
            try {
                this.getBroker().removeFromCache(entry);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                // empty catch block
            }
        }
    }

    private void unCache(Collection col) {
        Iterator i = col.iterator();
        while (i.hasNext()) {
            try {
                this.getBroker().removeFromCache(i.next());
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                // empty catch block
            }
        }
    }

    private PersistenceBroker getBroker() {
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        return broker;
    }

    protected LockEntry getWriter(Object obj) {
        this.removeTimedOutLocks(DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("oidString", oid.toString());
        criteria.addEqualTo("lockType", new Integer(LockEntry.LOCK_WRITE));
        Query q = QueryFactory.newQuery(class$ojb$odmg$locking$LockEntry == null ? (class$ojb$odmg$locking$LockEntry = AbstractLockStrategy.class$("ojb.odmg.locking.LockEntry")) : class$ojb$odmg$locking$LockEntry, criteria);
        try {
            LockEntry result = (LockEntry)this.getBroker().getObjectByQuery(q);
            this.unCache(result);
            return result;
        }
        catch (PersistenceBrokerException e) {
            return null;
        }
    }

    protected Collection getReaders(Object obj) {
        this.removeTimedOutLocks(DEFAULT_LOCK_TIMEOUT);
        Identity oid = new Identity(obj);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("oidString", oid.toString());
        criteria.addEqualTo("lockType", new Integer(LockEntry.LOCK_READ));
        Query q = QueryFactory.newQuery(class$ojb$odmg$locking$LockEntry == null ? (class$ojb$odmg$locking$LockEntry = AbstractLockStrategy.class$("ojb.odmg.locking.LockEntry")) : class$ojb$odmg$locking$LockEntry, criteria);
        try {
            Collection result = this.getBroker().getCollectionByQuery(q);
            this.unCache(result);
            return result;
        }
        catch (PersistenceBrokerException e) {
            return new Vector();
        }
    }

    protected boolean addReader(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lock = new LockEntry(new Identity(obj).toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj.getClass()), LockEntry.LOCK_READ);
            this.getBroker().store(lock);
            this.unCache(lock);
            return true;
        }
        catch (PersistenceBrokerException e) {
            return false;
        }
    }

    protected void removeReader(TransactionImpl tx, Object obj) {
        try {
            LockEntry lock = new LockEntry(new Identity(obj).toString(), tx.getGUID());
            this.getBroker().delete(lock);
            this.unCache(lock);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    protected void removeWriter(LockEntry writer) {
        try {
            this.getBroker().delete(writer);
            this.unCache(writer);
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    protected void removeTimedOutLocks(long timeout) {
        int count = 0;
        long maxAge = System.currentTimeMillis() - timeout;
        Criteria criteria = new Criteria();
        criteria.addLessThan("timestamp", new Long(maxAge));
        Query q = QueryFactory.newQuery(class$ojb$odmg$locking$LockEntry == null ? (class$ojb$odmg$locking$LockEntry = AbstractLockStrategy.class$("ojb.odmg.locking.LockEntry")) : class$ojb$odmg$locking$LockEntry, criteria);
        try {
            Iterator i = this.getBroker().getIteratorByQuery(q);
            while (i.hasNext()) {
                this.getBroker().delete(i.next());
                ++count;
            }
            if (count > 0) {
                System.out.println("Removed " + count + " timedout locks");
            }
        }
        catch (PersistenceBrokerException e) {
            // empty catch block
        }
    }

    protected boolean upgradeLock(LockEntry reader) {
        reader.setLockType(LockEntry.LOCK_WRITE);
        try {
            this.getBroker().store(reader);
            this.unCache(reader);
            return true;
        }
        catch (PersistenceBrokerException e) {
            return false;
        }
    }

    protected boolean setWriter(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lock = new LockEntry(new Identity(obj).toString(), tx.getGUID(), System.currentTimeMillis(), LockStrategyFactory.getIsolationLevel(obj.getClass()), LockEntry.LOCK_WRITE);
            this.getBroker().store(lock);
            this.unCache(lock);
            return true;
        }
        catch (PersistenceBrokerException e) {
            return false;
        }
    }

    protected boolean hasReadLock(TransactionImpl tx, Object obj) {
        this.removeTimedOutLocks(DEFAULT_LOCK_TIMEOUT);
        try {
            LockEntry lock = new LockEntry(new Identity(obj).toString(), tx.getGUID());
            Identity oid = new Identity(lock);
            LockEntry result = (LockEntry)this.getBroker().getObjectByIdentity(oid);
            this.unCache(result);
            return result != null;
        }
        catch (PersistenceBrokerException e) {
            return false;
        }
    }

    public abstract boolean checkWrite(TransactionImpl var1, Object var2);

    public abstract boolean checkRead(TransactionImpl var1, Object var2);

    public abstract boolean releaseLock(TransactionImpl var1, Object var2);

    public abstract boolean upgradeLock(TransactionImpl var1, Object var2);

    public abstract boolean writeLock(TransactionImpl var1, Object var2);

    public abstract boolean readLock(TransactionImpl var1, Object var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

