/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.validator;

import org.apache.uima.ruta.ide.parser.ast.ComponentDeclaration;
import org.apache.uima.ruta.ide.parser.ast.ComposedRuleElement;
import org.apache.uima.ruta.ide.parser.ast.FeatureMatchExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaPackageDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaQuantifierLiteralExpression;
import org.apache.uima.ruta.ide.parser.ast.RutaRule;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;

public class XMLOutputVisitor
extends ASTVisitor {
    private String document;
    private StringBuilder sb = new StringBuilder();

    public XMLOutputVisitor(String document) {
        this.document = document;
    }

    public boolean visitGeneral(ASTNode node) throws Exception {
        if (node instanceof RutaRule) {
            this.sb.append("<!-- " + this.document.substring(node.sourceStart(), node.sourceEnd()) + "-->\n");
        }
        this.sb.append("<");
        this.sb.append(node.getClass().getSimpleName());
        this.addAttributes(node);
        this.sb.append(">");
        this.sb.append("\n");
        return true;
    }

    private void addAttributes(ASTNode node) {
        Boolean disjunctive;
        RutaQuantifierLiteralExpression s;
        if (node instanceof RutaQuantifierLiteralExpression) {
            s = (RutaQuantifierLiteralExpression)node;
            this.sb.append(" value='");
            this.sb.append(s.getOperator());
            this.sb.append("'");
        }
        if (node instanceof ComposedRuleElement && (disjunctive = (s = (ComposedRuleElement)node).isDisjunctive()) != null) {
            this.sb.append(" value='");
            if (disjunctive.booleanValue()) {
                this.sb.append("Disjunctive");
            } else {
                this.sb.append("Conjunctive");
            }
            this.sb.append("'");
        }
        if (node instanceof FeatureMatchExpression) {
            s = (FeatureMatchExpression)node;
            this.sb.append(" feature='");
            this.sb.append(s.getFeature().getText());
            this.sb.append("'");
            if (s.getComparator() != null) {
                this.sb.append(" comparator='");
                this.sb.append(s.getComparator().getText());
                this.sb.append("'");
            }
        }
        if (node instanceof SimpleReference) {
            s = (SimpleReference)node;
            this.sb.append(" value='");
            this.sb.append(s.getStringRepresentation());
            this.sb.append("'");
        }
        if (node instanceof RutaPackageDeclaration) {
            // empty if block
        }
        if (node instanceof ComponentDeclaration) {
            s = (ComponentDeclaration)node;
            this.sb.append(" type='");
            this.sb.append(s.getType());
            this.sb.append("'");
        }
        if (node instanceof RutaVariableReference) {
            s = (RutaVariableReference)node;
            this.sb.append(" type='");
            this.sb.append(s.getType());
            this.sb.append("'");
        }
        if (node instanceof RutaAction) {
            s = (RutaAction)node;
            this.sb.append(" type='");
            this.sb.append(s.getName());
            this.sb.append("'");
        }
        if (node instanceof RutaCondition) {
            s = (RutaCondition)node;
            this.sb.append(" type='");
            this.sb.append(s.getName());
            this.sb.append("'");
        }
        if (node instanceof StringLiteral) {
            s = (StringLiteral)node;
            this.sb.append(" value='");
            this.sb.append(s.getValue());
            this.sb.append("'");
        }
        if (node instanceof NumericLiteral) {
            s = (NumericLiteral)node;
            this.sb.append(" value='");
            this.sb.append(s.getValue());
            this.sb.append("'");
        }
    }

    public void endvisitGeneral(ASTNode node) throws Exception {
        this.sb.append("</");
        this.sb.append(node.getClass().getSimpleName());
        this.sb.append(">");
        this.sb.append("\n");
    }

    public String getXML() {
        return this.sb.toString();
    }
}

