/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.editor.AbstractDocumentListener;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.CasEditorViewPage;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.apache.uima.caseditor.editor.ICasEditor;
import org.apache.uima.caseditor.editor.ICasEditorInputListener;
import org.apache.uima.caseditor.editor.SubPageSite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public abstract class CasEditorView
extends PageBookView {
    private final String editorNotAvailableMessage;
    private Map<ICasEditor, ICasEditorInputListener> editorListenerMap = new HashMap<ICasEditor, ICasEditorInputListener>();
    private Map<ICasEditor, ICasDocumentListener> documentListenerMap = new HashMap<ICasEditor, ICasDocumentListener>();

    public CasEditorView(String editorNotAvailableMessage) {
        this.editorNotAvailableMessage = editorNotAvailableMessage;
    }

    protected boolean isRecreatePageOnCASViewSwitch() {
        return false;
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(this.editorNotAvailableMessage);
        return page;
    }

    protected abstract IPageBookViewPage doCreatePage(ICasEditor var1);

    private void createViewPage(CasEditorViewPage casViewPageBookedPage, ICasEditor editor) {
        IPageBookViewPage page = this.doCreatePage(editor);
        if (page != null) {
            try {
                page.init((IPageSite)new SubPageSite(casViewPageBookedPage.getSite()));
            }
            catch (PartInitException e) {
                CasEditorPlugin.log(e);
            }
            casViewPageBookedPage.setCASViewPage(page);
        } else {
            casViewPageBookedPage.setCASViewPage(null);
        }
    }

    protected final PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        PageBookView.PageRec result = null;
        if (part instanceof ICasEditor) {
            final ICasEditor editor = (ICasEditor)part;
            final CasEditorViewPage casViewPageBookedPage = new CasEditorViewPage(this.editorNotAvailableMessage);
            if (editor.getDocument() != null) {
                AbstractDocumentListener documentListener = new AbstractDocumentListener(){

                    @Override
                    public void viewChanged(String oldViewName, String newViewName) {
                        if (CasEditorView.this.isRecreatePageOnCASViewSwitch()) {
                            CasEditorView.this.createViewPage(casViewPageBookedPage, editor);
                        }
                    }
                };
                editor.getDocument().addChangeListener(documentListener);
                this.documentListenerMap.put(editor, documentListener);
            }
            ICasEditorInputListener inputListener = new ICasEditorInputListener(){

                @Override
                public void casDocumentChanged(IEditorInput oldInput, ICasDocument oldDocument, IEditorInput newInput, ICasDocument newDocument) {
                    CasEditorView.this.createViewPage(casViewPageBookedPage, editor);
                    ICasDocumentListener changeListener = CasEditorView.this.documentListenerMap.get(editor);
                    if (changeListener != null) {
                        if (oldDocument != null) {
                            oldDocument.removeChangeListener(changeListener);
                        }
                        if (newDocument != null) {
                            newDocument.addChangeListener(changeListener);
                        }
                    }
                }
            };
            this.editorListenerMap.put(editor, inputListener);
            editor.addCasEditorInputListener(inputListener);
            this.initPage((IPageBookViewPage)casViewPageBookedPage);
            casViewPageBookedPage.createControl((Composite)this.getPageBook());
            this.createViewPage(casViewPageBookedPage, editor);
            result = new PageBookView.PageRec((IWorkbenchPart)editor, (IPage)casViewPageBookedPage);
        }
        return result;
    }

    protected IWorkbenchPart getBootstrapPart() {
        return this.getSite().getPage().getActiveEditor();
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (part instanceof ICasEditor) {
            ICasEditor editor = (ICasEditor)part;
            ICasEditorInputListener editorListener = this.editorListenerMap.remove(part);
            if (editorListener != null) {
                editor.removeCasEditorInputListener(editorListener);
            }
            ICasDocumentListener documentListener = this.documentListenerMap.remove(part);
            ICasDocument document = editor.getDocument();
            if (documentListener != null && document != null) {
                document.removeChangeListener(documentListener);
            }
        }
        pageRecord.page.dispose();
        pageRecord.dispose();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof AnnotationEditor;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }

    public void dispose() {
        for (Map.Entry<ICasEditor, ICasEditorInputListener> entry : this.editorListenerMap.entrySet()) {
            entry.getKey().removeCasEditorInputListener(entry.getValue());
        }
        this.editorListenerMap.clear();
        for (Map.Entry<ICasEditor, Object> entry : this.documentListenerMap.entrySet()) {
            ICasDocument document = entry.getKey().getDocument();
            if (document == null) continue;
            document.removeChangeListener((ICasDocumentListener)entry.getValue());
        }
        this.documentListenerMap.clear();
        super.dispose();
    }
}

