/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.number;

import java.util.List;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.expression.number.AbstractNumberExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedNumberExpression
extends AbstractNumberExpression {
    private final List<NumberExpression> expressions;
    private final List<String> ops;

    public ComposedNumberExpression(List<NumberExpression> expressions, List<String> ops) {
        this.expressions = expressions;
        this.ops = ops;
    }

    @Override
    public double getDoubleValue(RutaStatement parent) {
        NumberExpression numberExpression = this.getExpressions().get(0);
        if (numberExpression == null) {
            return 0.0;
        }
        double result = numberExpression.getDoubleValue(parent);
        for (int i = 0; i < this.getOperators().size(); ++i) {
            double second = 0.0;
            if (this.getExpressions().size() > i + 1) {
                second = this.getExpressions().get(i + 1).getDoubleValue(parent);
            }
            result = this.calculate(result, second, this.getOperators().get(i));
        }
        return result;
    }

    @Override
    public float getFloatValue(RutaStatement parent) {
        NumberExpression numberExpression = this.getExpressions().get(0);
        if (numberExpression == null) {
            return 0.0f;
        }
        float result = numberExpression.getFloatValue(parent);
        for (int i = 0; i < this.getOperators().size(); ++i) {
            float second = 0.0f;
            if (this.getExpressions().size() > i + 1) {
                second = this.getExpressions().get(i + 1).getFloatValue(parent);
            }
            result = this.calculate(result, second, this.getOperators().get(i));
        }
        return result;
    }

    @Override
    public int getIntegerValue(RutaStatement parent) {
        int result = this.getExpressions().get(0).getIntegerValue(parent);
        for (int i = 0; i < this.getOperators().size(); ++i) {
            int second = 0;
            if (this.getExpressions().size() > i + 1) {
                second = this.getExpressions().get(i + 1).getIntegerValue(parent);
            }
            result = this.calculate(result, second, this.getOperators().get(i));
        }
        return result;
    }

    @Override
    public String getStringValue(RutaStatement parent) {
        return "" + this.getDoubleValue(parent);
    }

    public List<NumberExpression> getExpressions() {
        return this.expressions;
    }

    public List<String> getOperators() {
        return this.ops;
    }
}

