/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views.util;

import java.util.Collection;
import java.util.HashMap;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.ruta.testing.ui.views.TestCasData;
import org.apache.uima.ruta.testing.ui.views.evalDataTable.TypeEvalData;

public class EvalDataProcessor {
    public static void calculateEvaluatData(TestCasData data, CAS resultCas) {
        data.setEvaluationStatus(true);
        TypeSystem ts = resultCas.getTypeSystem();
        Type falsePositiveType = ts.getType("org.apache.uima.ruta.type.FalsePositive");
        Type falseNegativeType = ts.getType("org.apache.uima.ruta.type.FalseNegative");
        Type truePositiveType = ts.getType("org.apache.uima.ruta.type.TruePositive");
        Feature originalFeature = truePositiveType.getFeatureByBaseName("original");
        int falsePositiveCount = resultCas.getAnnotationIndex(falsePositiveType).size();
        int falseNegativeCount = resultCas.getAnnotationIndex(falseNegativeType).size();
        int truePositiveCount = resultCas.getAnnotationIndex(truePositiveType).size();
        data.setTruePositiveCount(truePositiveCount);
        data.setFalsePositiveCount(falsePositiveCount);
        data.setFalseNegativeCount(falseNegativeCount);
        HashMap<String, TypeEvalData> map = new HashMap<String, TypeEvalData>();
        map.put(" Total", new TypeEvalData("Total", truePositiveCount, falsePositiveCount, falseNegativeCount));
        AnnotationIndex index = resultCas.getAnnotationIndex(truePositiveType);
        FSIterator iter = index.iterator();
        if (originalFeature != null) {
            TypeEvalData newData;
            int oldCount;
            TypeEvalData element;
            String typeName;
            FeatureStructure fs;
            AnnotationFS a;
            while (iter.isValid()) {
                a = (AnnotationFS)iter.next();
                fs = a.getFeatureValue(originalFeature);
                typeName = fs.getType().getName();
                if (map.containsKey(typeName)) {
                    element = (TypeEvalData)map.get(typeName);
                    oldCount = element.getTruePositives();
                    element.setTruePositives(oldCount + 1);
                    continue;
                }
                newData = new TypeEvalData(typeName, 1, 0, 0);
                map.put(typeName, newData);
            }
            index = resultCas.getAnnotationIndex(falsePositiveType);
            iter = index.iterator();
            while (iter.isValid()) {
                a = (AnnotationFS)iter.next();
                fs = a.getFeatureValue(originalFeature);
                typeName = fs.getType().getName();
                if (map.containsKey(typeName)) {
                    element = (TypeEvalData)map.get(typeName);
                    oldCount = element.getFalsePositives();
                    element.setFalsePositives(oldCount + 1);
                    continue;
                }
                newData = new TypeEvalData(typeName, 0, 1, 0);
                map.put(typeName, newData);
            }
            index = resultCas.getAnnotationIndex(falseNegativeType);
            iter = index.iterator();
            while (iter.isValid()) {
                a = (AnnotationFS)iter.next();
                fs = a.getFeatureValue(originalFeature);
                typeName = fs.getType().getName();
                if (map.containsKey(typeName)) {
                    element = (TypeEvalData)map.get(typeName);
                    oldCount = element.getFalseNegatives();
                    element.setFalseNegatives(oldCount + 1);
                    continue;
                }
                newData = new TypeEvalData(typeName, 0, 0, 1);
                map.put(typeName, newData);
            }
            data.setTypeEvalData(map);
            Collection col = map.values();
            for (TypeEvalData typeEvalData : col) {
                typeEvalData.calcFOne();
            }
            return;
        }
    }
}

