/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.CapabilitySection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialogMultiColTable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AddCapabilityFeatureDialog
extends AbstractDialogMultiColTable {
    public String[] features;
    public boolean[] inputs;
    public boolean[] outputs;
    public boolean allFeaturesInput = false;
    public boolean allFeaturesOutput = false;
    private Feature[] allFeatures;
    private Capability capability;
    private Type selectedType;
    private boolean inputNotAllowed = true;
    private static Feature[] featureArray0 = new Feature[0];

    public AddCapabilityFeatureDialog(AbstractSection aSection, Type aSelectedType, Capability c) {
        super(aSection, "Specify features input and / or output", "Designate by mouse clicking one or more features in the Input and/or Output column, to designate as Input and/or Output press \"OK\"");
        this.selectedType = aSelectedType;
        this.allFeatures = this.selectedType.getFeatures().toArray(featureArray0);
        Arrays.sort(this.allFeatures);
        this.capability = c;
        TypeOrFeature[] localInputs = c.getInputs();
        String typeName = this.selectedType.getName();
        if (null != localInputs) {
            for (int i = 0; i < localInputs.length; ++i) {
                if (!localInputs[i].isType() || !typeName.equals(localInputs[i].getName())) continue;
                this.inputNotAllowed = false;
                break;
            }
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Tree tree = this.newTree(composite, 68098);
        ((GridData)tree.getLayoutData()).heightHint = 100;
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        new TreeColumn(tree, 0).setText("Feature Name");
        new TreeColumn(tree, 0).setText("Input");
        new TreeColumn(tree, 0).setText("Output");
        TreeItem item = new TreeItem(tree, 0);
        item.setText(0, "<all features>");
        TypeOrFeature tof = AbstractSection.getTypeOrFeature(this.capability.getInputs(), this.selectedType.getName());
        this.setChecked(item, 1, null == tof ? false : tof.isAllAnnotatorFeatures());
        tof = AbstractSection.getTypeOrFeature(this.capability.getOutputs(), this.selectedType.getName());
        this.setChecked(item, 2, null == tof ? false : tof.isAllAnnotatorFeatures());
        for (int i = 0; i < this.allFeatures.length; ++i) {
            item = new TreeItem(tree, 0);
            item.setText(0, this.allFeatures[i].getShortName());
            this.setChecked(item, 1, CapabilitySection.isInput(this.getTypeFeature(this.allFeatures[i]), this.capability));
            this.setChecked(item, 2, CapabilitySection.isOutput(this.getTypeFeature(this.allFeatures[i]), this.capability));
        }
        tree.removeListener(13, (Listener)this);
        tree.addListener(3, (Listener)this);
        this.section.packTree(tree);
        this.newErrorMessage(composite);
        return composite;
    }

    protected String getTypeFeature(Feature feature) {
        return this.selectedType.getName() + ':' + feature.getShortName();
    }

    @Override
    protected void toggleValue(TableItem item, int col) {
        if (1 == col && this.inputNotAllowed) {
            Utility.popMessage("Input not allowed", "Input not allowed unless the type itself is also marked as an input.", 1);
            return;
        }
        super.toggleValue(item, col);
        if (item.getText(col).equals(this.checkedIndicator(col))) {
            if (item.getText(0).equals("<all features>")) {
                this.uncheckAllOtherFeatures(col);
            } else {
                this.setChecked(this.f_tree.getItem(0), col, false);
            }
        }
    }

    private void uncheckAllOtherFeatures(int column) {
        TreeItem[] items = this.f_tree.getItems();
        for (int i = 1; i < items.length; ++i) {
            this.setChecked(items[i], column, false);
        }
    }

    @Override
    public void copyValuesFromGUI() {
        int i;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Boolean> ins = new ArrayList<Boolean>();
        ArrayList<Boolean> outs = new ArrayList<Boolean>();
        for (i = this.f_tree.getItemCount() - 1; i >= 1; --i) {
            TreeItem item = this.f_tree.getItem(i);
            if (!item.getText(1).equals(this.checkedIndicator(1)) && !item.getText(2).equals(this.checkedIndicator(2))) continue;
            names.add(item.getText(0));
            ins.add(item.getText(1).equals(this.checkedIndicator(1)));
            outs.add(item.getText(2).equals(this.checkedIndicator(2)));
        }
        this.features = names.toArray(stringArray0);
        this.inputs = new boolean[this.features.length];
        this.outputs = new boolean[this.features.length];
        for (i = 0; i < this.features.length; ++i) {
            this.inputs[i] = (Boolean)ins.get(i);
            this.outputs[i] = (Boolean)outs.get(i);
        }
        TreeItem item = this.f_tree.getItem(0);
        this.allFeaturesInput = item.getText(1).equals(this.checkedIndicator(1));
        this.allFeaturesOutput = item.getText(2).equals(this.checkedIndicator(2));
    }
}

