/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import org.apache.uima.ruta.resource.ResourcePathResourceLoader;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class RutaResourceLoader
implements ResourceLoader {
    private final ResourceLoader wrapped;
    private final ResourceLoader fallback;
    private final ClassLoader classLoader;

    public RutaResourceLoader(String[] paths, ClassLoader classLoader) {
        this.wrapped = new PathMatchingResourcePatternResolver((ResourceLoader)new ResourcePathResourceLoader(paths));
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.fallback = new DefaultResourceLoader(this.classLoader);
    }

    public RutaResourceLoader(String[] paths) {
        this(paths, null);
    }

    public Resource getResource(String location) {
        Resource resource = this.wrapped.getResource(location);
        if (!resource.exists()) {
            resource = this.fallback.getResource(location);
        }
        return resource;
    }

    public Resource getResourceWithDotNotation(String location, String extension) {
        String path = location.replaceAll("[.]", "/") + extension;
        return this.getResource(path);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

