/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class NormalizeUnicode
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return StringValue.EMPTY_STRING;
        }
        int n = 2;
        if (this.argument.length == 2) {
            String string = this.argument[1].evaluateAsString(xPathContext).trim();
            if (string.equalsIgnoreCase("NFC")) {
                n = 2;
            } else if (string.equalsIgnoreCase("NFD")) {
                n = 0;
            } else if (string.equalsIgnoreCase("NFKC")) {
                n = 3;
            } else if (string.equalsIgnoreCase("NFKD")) {
                n = 1;
            } else {
                if (string.length() == 0) {
                    return stringValue;
                }
                String string2 = "Normalization form " + string + " is not supported";
                DynamicError dynamicError = new DynamicError(string2);
                dynamicError.setErrorCode("FOCH0003");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
        }
        boolean bl = true;
        CharSequence charSequence = stringValue.getStringValueCS();
        if (charSequence instanceof CompressedWhitespace) {
            return stringValue;
        }
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (charSequence.charAt(i) <= '\u007f') continue;
            bl = false;
            break;
        }
        if (bl) {
            return stringValue;
        }
        Normalizer normalizer = new Normalizer((byte)n);
        CharSequence charSequence2 = normalizer.normalize(stringValue.getStringValueCS());
        return StringValue.makeStringValue(charSequence2);
    }
}

