/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.GDateValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;
import net.sf.saxon.value.Whitespace;

public class GMonthDayValue
extends GDateValue {
    private static Pattern regex = Pattern.compile("--([0-9][0-9]-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    public GMonthDayValue(CharSequence charSequence) throws XPathException {
        Matcher matcher = regex.matcher(Whitespace.trimWhitespace(charSequence));
        if (!matcher.matches()) {
            throw new DynamicError("Cannot convert '" + charSequence + "' to a gMonthDay");
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        String string3 = "2000-" + string + (string2 == null ? "" : string2);
        this.setLexicalValue(string3);
        this.typeLabel = BuiltInAtomicType.G_MONTH_DAY;
    }

    public GMonthDayValue(byte by, byte by2, int n) {
        this(by, by2, n, BuiltInAtomicType.G_MONTH_DAY);
    }

    public GMonthDayValue(byte by, byte by2, int n, AtomicType atomicType) {
        this.year = 2000;
        this.month = by;
        this.day = by2;
        this.setTimezoneInMinutes(n);
        this.typeLabel = atomicType;
    }

    public AtomicValue copy(AtomicType atomicType) {
        GMonthDayValue gMonthDayValue = new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
        gMonthDayValue.typeLabel = atomicType;
        return gMonthDayValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_MONTH_DAY;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 524: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert gMonthDay to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        fastStringBuffer.append("--");
        GMonthDayValue.appendTwoDigits(fastStringBuffer, this.month);
        fastStringBuffer.append('-');
        GMonthDayValue.appendTwoDigits(fastStringBuffer, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(fastStringBuffer);
        }
        return fastStringBuffer;
    }

    public CalendarValue add(DurationValue durationValue) throws XPathException {
        DynamicError dynamicError = new DynamicError("Cannot add a duration to an xs:gMonthDay");
        dynamicError.setErrorCode("XPTY0004");
        throw dynamicError;
    }

    public CalendarValue adjustTimezone(int n) {
        throw new UnsupportedOperationException("Cannot adjust timezone on an xs:gMonthDay");
    }
}

