/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.internal.util.IntVector;

abstract class FSsTobeAddedback
implements AutoCloseable {
    static final boolean SHOW = false;
    static final AtomicInteger removes = new AtomicInteger(0);

    FSsTobeAddedback() {
    }

    @Override
    public void close() {
        this.addback();
        ((FSsTobeAddedbackMultiple)this).cas.dropProtectIndexesLevel();
    }

    protected void logPart(FSIndexRepository view) {
        System.out.format("%,d tobeReindexed: view: %s", removes.incrementAndGet(), view);
    }

    protected void log(FSIndexRepositoryImpl view, int count) {
    }

    private void logPart(int fsAddr, FSIndexRepositoryImpl view) {
        this.log(view);
        System.out.format(",  fsAddr = %,d", fsAddr);
    }

    protected void log(int fsAddr, FSIndexRepositoryImpl view, int count) {
    }

    protected void log(FSIndexRepositoryImpl view) {
    }

    protected void log(int fsAddr, FSIndexRepositoryImpl view) {
    }

    void recordRemove(FSIndexRepositoryImpl view) {
        throw new UnsupportedOperationException();
    }

    void recordRemove(FSIndexRepositoryImpl view, int count) {
        if (count != 1) {
            throw new UnsupportedOperationException();
        }
        this.recordRemove(view);
    }

    void recordRemove(int fsAddr, FSIndexRepositoryImpl view) {
        throw new UnsupportedOperationException();
    }

    void recordRemove(int fsAddr, FSIndexRepositoryImpl view, int count) {
        if (count != 1) {
            throw new UnsupportedOperationException();
        }
        this.recordRemove(fsAddr, view);
    }

    void addback() {
        throw new UnsupportedOperationException();
    }

    void addback(int fsAddr) {
        throw new UnsupportedOperationException();
    }

    abstract void clear();

    public static FSsTobeAddedback createSingle() {
        return FSIndexRepositoryImpl.IS_ALLOW_DUP_ADD_2_INDEXES ? new FSsTobeAddedbackSingleCounts() : new FSsTobeAddedbackSingle();
    }

    public static FSsTobeAddedback createMultiple(CASImpl cas) {
        return FSIndexRepositoryImpl.IS_ALLOW_DUP_ADD_2_INDEXES ? new FSsTobeAddedbackMultipleCounts(cas) : new FSsTobeAddedbackMultiple(cas);
    }

    static class FSsTobeAddedbackMultipleCounts
    extends FSsTobeAddedbackMultiple {
        public FSsTobeAddedbackMultipleCounts(CASImpl cas) {
            super(cas);
        }

        @Override
        void recordRemove(int fsAddr, FSIndexRepositoryImpl view, int count) {
            this.log(fsAddr, view, count);
            ArrayList<Object> countsAndViews = (ArrayList<Object>)this.fss2views.get(fsAddr);
            if (null == countsAndViews) {
                countsAndViews = new ArrayList<Object>();
                this.fss2views.put(fsAddr, countsAndViews);
            }
            countsAndViews.add(count);
            countsAndViews.add(view);
        }

        @Override
        void addback() {
            for (Map.Entry e : this.fss2views.entrySet()) {
                int fsAddr = (Integer)e.getKey();
                List countsAndViews = (List)e.getValue();
                int i = 0;
                while (i < countsAndViews.size()) {
                    int count = (Integer)countsAndViews.get(i++);
                    FSIndexRepositoryImpl view = (FSIndexRepositoryImpl)countsAndViews.get(i++);
                    view.ll_addback(fsAddr, count);
                }
            }
            this.clear();
        }

        @Override
        void clear() {
            this.fss2views.clear();
        }
    }

    static class FSsTobeAddedbackMultiple
    extends FSsTobeAddedback {
        final Map<Integer, List<?>> fss2views = new HashMap();
        final CASImpl cas;

        FSsTobeAddedbackMultiple(CASImpl cas) {
            this.cas = cas;
        }

        @Override
        void recordRemove(int fsAddr, FSIndexRepositoryImpl view) {
            this.log(fsAddr, view);
            List<?> irList = this.fss2views.get(fsAddr);
            if (null == irList) {
                irList = new ArrayList();
                this.fss2views.put(fsAddr, irList);
            }
            irList.add(view);
        }

        @Override
        void addback() {
            for (Map.Entry<Integer, List<?>> e : this.fss2views.entrySet()) {
                int fsAddr = e.getKey();
                List<?> views = e.getValue();
                for (FSIndexRepositoryImpl ir : views) {
                    ir.ll_addback(fsAddr, 1);
                }
            }
            this.clear();
        }

        @Override
        void clear() {
            this.fss2views.clear();
        }
    }

    static class FSsTobeAddedbackSingleCounts
    extends FSsTobeAddedbackSingle {
        final IntVector counts = new IntVector(4);

        FSsTobeAddedbackSingleCounts() {
        }

        @Override
        void recordRemove(FSIndexRepositoryImpl view, int count) {
            this.log(view, count);
            this.views.add(view);
            this.counts.add(count);
        }

        @Override
        void addback(int fsAddr) {
            int i = 0;
            for (FSIndexRepositoryImpl ir : this.views) {
                ir.ll_addback(fsAddr, this.counts.get(i++));
            }
            this.clear();
        }

        @Override
        void clear() {
            this.views.clear();
            this.counts.removeAllElementsAdjustSizeDown();
        }
    }

    static class FSsTobeAddedbackSingle
    extends FSsTobeAddedback {
        final List<FSIndexRepositoryImpl> views = new ArrayList<FSIndexRepositoryImpl>();

        FSsTobeAddedbackSingle() {
        }

        @Override
        void recordRemove(FSIndexRepositoryImpl view) {
            this.log(view);
            this.views.add(view);
        }

        @Override
        void recordRemove(int fsAddr, FSIndexRepositoryImpl view) {
            this.recordRemove(view);
        }

        @Override
        void recordRemove(int fsAddr, FSIndexRepositoryImpl view, int count) {
            if (count != 1) {
                throw new RuntimeException("internal error");
            }
            this.recordRemove(view);
        }

        @Override
        void addback(int fsAddr) {
            for (FSIndexRepositoryImpl ir : this.views) {
                ir.ll_addback(fsAddr, 1);
            }
            this.clear();
        }

        @Override
        void clear() {
            this.views.clear();
        }
    }
}

