/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.text.AnnotationFS;

public class Subiterator<T extends AnnotationFS>
extends FSIteratorImplBase<T> {
    private ArrayList<T> list = null;
    private int pos = 0;
    private final FSIteratorImplBase<T> it;
    private final FSIndexRepositoryImpl fsIndexRepo;
    private final AnnotationFS boundingAnnotation;
    private final int boundingBegin;
    private final int boundingEnd;
    private int prevEnd = 0;
    private final boolean ambiguous;
    private final boolean strict;
    private final boolean isBounded;
    private boolean isListForm = false;
    private final boolean isBeginEndCompare;
    private final int startId;

    Subiterator(FSIterator<T> it, AnnotationFS boundingAnnotation, int boundingBegin, int boundingEnd, boolean ambiguous, boolean strict, boolean isBounded, FSIndexRepositoryImpl fsIndexRepo) {
        this.isBounded = isBounded;
        this.isBeginEndCompare = this.isBounded ? boundingAnnotation == null : false;
        this.it = (FSIteratorImplBase)it;
        this.boundingAnnotation = this.isBounded ? boundingAnnotation : null;
        this.boundingBegin = boundingAnnotation == null ? boundingBegin : boundingAnnotation.getBegin();
        this.boundingEnd = boundingAnnotation == null ? boundingEnd : boundingAnnotation.getEnd();
        this.ambiguous = ambiguous;
        this.strict = strict;
        this.fsIndexRepo = fsIndexRepo;
        this.moveToStart();
        this.startId = this.isValid() ? ((FeatureStructureImpl)this.get()).getAddress() : 0;
    }

    private void convertToListForm() {
        this.moveToStart();
        this.list = new ArrayList();
        while (this.isValid()) {
            this.prevEnd = this.it.getEnd();
            this.list.add(this.it.get());
            this.it.moveToNext();
            this.movePastPrevAnnotation();
            this.adjustForStrictForward();
        }
        this.isListForm = true;
    }

    private void moveToExact(FeatureStructureImpl targetAnnotation) {
        this.it.moveTo(targetAnnotation);
        while (this.it.isValid() && targetAnnotation.getAddress() != ((FeatureStructureImpl)this.it.get()).getAddress()) {
            this.it.moveToNext();
        }
    }

    private void moveToStart() {
        if (!this.isBounded) {
            this.it.moveToFirst();
        } else if (this.isBeginEndCompare) {
            this.it.moveTo(this.boundingBegin, this.boundingEnd);
        } else {
            this.it.moveTo(this.boundingAnnotation);
            this.movePastAnnot();
        }
        this.adjustForStrictForward();
        this.setPrevEnd();
    }

    private void setPrevEnd() {
        if (!this.ambiguous && this.it.isValid()) {
            this.prevEnd = this.it.getEnd();
        }
    }

    private void movePastAnnot() {
        Comparator<AnnotationFS> annotationComparator = this.getAnnotationComparator();
        while (this.isValid() && 0 == annotationComparator.compare(this.boundingAnnotation, (AnnotationFS)this.it.get())) {
            this.it.moveToNext();
        }
    }

    private Comparator<AnnotationFS> getAnnotationComparator() {
        return this.fsIndexRepo.getAnnotationFsComparator();
    }

    private void adjustAfterMoveToForBeginEndComparator(AnnotationFS fs) {
        int begin = fs.getBegin();
        int end = fs.getEnd();
        while (this.it.isValid() && this.it.getBegin() == begin && this.it.getEnd() == end) {
            this.it.moveToPrevious();
        }
        if (this.it.isValid()) {
            this.it.moveToNext();
        } else {
            this.moveToStart();
        }
    }

    private void adjustForStrictForward() {
        if (this.strict && this.isBounded) {
            while (this.it.isValid() && this.it.getEnd() > this.boundingEnd) {
                this.it.moveToNext();
            }
        }
    }

    private void movePastPrevAnnotation() {
        if (!this.ambiguous) {
            while (this.it.isValid() && this.it.getBegin() < this.prevEnd) {
                this.it.moveToNext();
            }
        }
    }

    private void adjustForStrictBackward() {
        if (this.strict && this.isBounded) {
            while (this.it.isValid() && this.it.getEnd() > this.boundingEnd) {
                this.it.moveToPrevious();
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.isListForm ? this.pos >= 0 && this.pos < this.list.size() : this.it.isValid() && (!this.isBounded || this.it.getBegin() <= this.boundingEnd);
    }

    @Override
    public T get() throws NoSuchElementException {
        if (this.isListForm) {
            if (this.pos >= 0 && this.pos < this.list.size()) {
                return (T)((AnnotationFS)this.list.get(this.pos));
            }
        } else if (this.isValid()) {
            return (T)((AnnotationFS)this.it.get());
        }
        throw new NoSuchElementException();
    }

    @Override
    public void moveToNext() {
        if (this.isListForm) {
            ++this.pos;
            return;
        }
        this.it.moveToNext();
        if (!this.ambiguous) {
            this.movePastPrevAnnotation();
        }
        this.adjustForStrictForward();
        if (this.isBounded && this.it.isValid() && ((AnnotationFS)this.it.get()).getBegin() > this.boundingEnd) {
            this.it.moveToLast();
            this.it.moveToNext();
        } else {
            this.setPrevEnd();
        }
    }

    @Override
    public void moveToPrevious() {
        if (this.isListForm) {
            --this.pos;
            return;
        }
        if (!this.ambiguous) {
            FeatureStructureImpl currentAnnotation = (FeatureStructureImpl)this.it.get();
            this.convertToListForm();
            this.moveToExact(currentAnnotation);
            --this.pos;
            return;
        }
        if (this.isBounded && this.isValid() && ((FeatureStructureImpl)this.it.get()).getAddress() == this.startId) {
            this.it.moveToFirst();
            this.it.moveToPrevious();
        } else {
            this.it.moveToPrevious();
            this.adjustForStrictBackward();
        }
    }

    @Override
    public void moveToFirst() {
        if (this.isListForm) {
            this.pos = 0;
        } else {
            this.moveToStart();
        }
    }

    @Override
    public void moveToLast() {
        if (this.isListForm) {
            this.pos = this.list.size() - 1;
        } else {
            this.convertToListForm();
            this.pos = this.list.size() - 1;
        }
    }

    static Comparator<AnnotationFS> getAnnotationBeginEndComparator(final int boundingBegin, final int boundingEnd) {
        return new Comparator<AnnotationFS>(){

            @Override
            public int compare(AnnotationFS o1, AnnotationFS o2) {
                AnnotationFS a = o1 == null ? o2 : o1;
                boolean isReverse = o1 == null;
                int b = a.getBegin();
                if (b < boundingBegin) {
                    return isReverse ? 1 : -1;
                }
                if (b > boundingBegin) {
                    return isReverse ? -1 : 1;
                }
                int e = a.getEnd();
                if (e < boundingEnd) {
                    return isReverse ? -1 : 1;
                }
                if (e > boundingEnd) {
                    return isReverse ? 1 : -1;
                }
                return 0;
            }
        };
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        block14: {
            AnnotationFS fsa;
            block12: {
                block13: {
                    block11: {
                        fsa = (AnnotationFS)fs;
                        if (!this.ambiguous && !this.isListForm) {
                            this.convertToListForm();
                        }
                        if (!this.isListForm) break block12;
                        Comparator<AnnotationFS> annotationComparator = this.getAnnotationComparator();
                        this.pos = Collections.binarySearch(this.list, (AnnotationFS)fs, annotationComparator);
                        if (this.pos < 0) break block13;
                        if (!this.isValid()) {
                            return;
                        }
                        FeatureStructure foundFs = this.get();
                        if (this.isBeginEndCompare) {
                            this.adjustAfterMoveToForBeginEndComparator(fsa);
                        } else {
                            do {
                                this.moveToPrevious();
                                if (!this.isValid()) break block11;
                            } while (annotationComparator.compare((AnnotationFS)this.get(), (AnnotationFS)foundFs) == 0);
                            this.moveToNext();
                        }
                        break block14;
                    }
                    this.moveToFirst();
                    break block14;
                }
                this.pos = -this.pos - 1;
                if (this.isBeginEndCompare) {
                    --this.pos;
                    this.adjustAfterMoveToForBeginEndComparator(fsa);
                }
                break block14;
            }
            this.it.moveTo(fs);
            if (this.isBeginEndCompare) {
                this.adjustAfterMoveToForBeginEndComparator(fsa);
            }
            this.adjustForStrictForward();
            if (this.it.isValid()) {
                if (this.it.getBegin() > this.boundingEnd) {
                    this.it.moveToLast();
                    this.it.moveToNext();
                } else if (this.fsIndexRepo.getAnnotationFsComparator().compare((AnnotationFS)this.it.get(), this.boundingAnnotation) < 0) {
                    this.it.moveToFirst();
                    this.it.moveToPrevious();
                }
            }
        }
    }

    @Override
    void moveTo(int begin, int end) {
        if (!this.ambiguous && !this.isListForm) {
            this.convertToListForm();
        }
        if (this.isListForm) {
            this.pos = Collections.binarySearch(this.list, null, Subiterator.getAnnotationBeginEndComparator(begin, end));
            if (this.pos >= 0) {
                if (!this.isValid()) {
                    return;
                }
                while (this.it.isValid() && this.it.getBegin() == begin && this.it.getEnd() == end) {
                    this.it.moveToPrevious();
                }
                if (this.it.isValid()) {
                    this.it.moveToNext();
                } else {
                    this.it.moveToFirst();
                }
            } else {
                this.pos = -this.pos - 1;
            }
        } else {
            this.it.moveTo(begin, end);
            while (this.isValid() && this.it.getBegin() == begin && this.it.getEnd() == end) {
                this.it.moveToPrevious();
            }
            this.adjustForStrictForward();
            if (this.it.isValid()) {
                if (this.it.getBegin() > this.boundingEnd) {
                    this.it.moveToLast();
                    this.it.moveToNext();
                } else if (this.fsIndexRepo.getAnnotationFsComparator().compare((AnnotationFS)this.it.get(), this.boundingAnnotation) < 0) {
                    this.it.moveToFirst();
                    this.it.moveToPrevious();
                }
            }
        }
    }

    @Override
    public FSIterator<T> copy() {
        Subiterator<T> copy = new Subiterator<T>(this.it, this.boundingAnnotation, this.boundingBegin, this.boundingEnd, this.ambiguous, this.strict, this.isBounded, this.fsIndexRepo);
        copy.list = this.list;
        copy.pos = this.pos;
        return copy;
    }
}

