/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.ShortArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class ShortArray
extends TOP
implements CommonPrimitiveArray<Short>,
ShortArrayFSImpl,
Iterable<Short> {
    public static final String _TypeName = "uima.cas.ShortArray";
    public static final int typeIndexID;
    public static final int type;
    private final short[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private ShortArray() {
        this.theArray = null;
    }

    public ShortArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new short[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    public ShortArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this.theArray = new short[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2size_nonHeapStoredArrays();
        }
    }

    @Override
    public short get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, short v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(short[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, short[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public short[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public void copyToArray(int srcPos, String[] dest, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcPos, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destPos] = Short.toString(this.theArray[i + srcPos]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcPos, int destPos, int length) {
        this._casView.checkArrayBounds(this.theArray.length, destPos, length);
        for (int i = 0; i < length; ++i) {
            this.theArray[i + destPos] = Short.parseShort(src[i + srcPos]);
        }
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    public short[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS v) {
        ShortArray bv = (ShortArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, Short.parseShort(v));
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ShortArray.this.size();
            }

            @Override
            public Short next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ShortArray.this.get(this.i++);
            }
        };
    }

    public static ShortArray create(JCas jcas, short[] a) {
        ShortArray shortArray = new ShortArray(jcas, a.length);
        shortArray.copyFromArray(a, 0, 0, a.length);
        return shortArray;
    }

    public boolean contains(short item) {
        for (short b : this.theArray) {
            if (b != item) continue;
            return true;
        }
        return false;
    }

    static {
        type = typeIndexID = JCasRegistry.register(ShortArray.class);
    }
}

