/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.BinaryCasSerDes;
import org.apache.uima.cas.impl.BinaryCasSerDes4;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.CommonSerDes;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.internal.util.SerializationUtils;
import org.apache.uima.util.CasLoadMode;
import org.apache.uima.util.XmlCasDeserializer;
import org.xml.sax.SAXException;

public class CasIOUtils {
    public static SerialFormat load(URL casUrl, CAS aCAS) throws IOException {
        return CasIOUtils.load(casUrl, null, aCAS, CasLoadMode.DEFAULT);
    }

    public static SerialFormat load(URL casUrl, URL tsiUrl, CAS aCAS, CasLoadMode casLoadMode) throws IOException {
        try (BufferedInputStream casIS = new BufferedInputStream(casUrl.openStream());){
            SerialFormat serialFormat;
            block11: {
                BufferedInputStream tsIS = tsiUrl == null ? null : new BufferedInputStream(tsiUrl.openStream());
                try {
                    serialFormat = CasIOUtils.load((InputStream)casIS, (InputStream)tsIS, aCAS, casLoadMode);
                    if (tsIS == null) break block11;
                }
                catch (Throwable throwable) {
                    if (tsIS != null) {
                        try {
                            tsIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tsIS.close();
            }
            return serialFormat;
        }
    }

    public static SerialFormat load(URL casUrl, URL tsiUrl, CAS aCAS, boolean leniently) throws IOException {
        return CasIOUtils.load(casUrl, tsiUrl, aCAS, leniently ? CasLoadMode.LENIENT : CasLoadMode.DEFAULT);
    }

    public static SerialFormat load(InputStream casInputStream, CAS aCAS) throws IOException {
        return CasIOUtils.load(casInputStream, null, aCAS, CasLoadMode.DEFAULT);
    }

    public static SerialFormat load(InputStream casInputStream, InputStream tsiInputStream, CAS aCAS) throws IOException {
        return CasIOUtils.load(casInputStream, tsiInputStream, aCAS, CasLoadMode.DEFAULT);
    }

    public static SerialFormat load(InputStream casInputStream, InputStream tsiInputStream, CAS aCAS, boolean leniently) throws IOException {
        return CasIOUtils.load(casInputStream, tsiInputStream, aCAS, leniently ? CasLoadMode.LENIENT : CasLoadMode.DEFAULT);
    }

    public static SerialFormat load(InputStream casInputStream, InputStream tsiInputStream, CAS aCAS, CasLoadMode casLoadMode) throws IOException {
        return CasIOUtils.load(casInputStream, tsiInputStream, aCAS, casLoadMode, null);
    }

    public static SerialFormat load(InputStream casInputStream, CAS aCAS, TypeSystem typeSystem) throws IOException {
        return CasIOUtils.load(casInputStream, null, aCAS, CasLoadMode.DEFAULT, (TypeSystemImpl)typeSystem);
    }

    private static SerialFormat load(InputStream casInputStream, InputStream tsiInputStream, CAS aCAS, CasLoadMode casLoadMode, TypeSystemImpl typeSystem) throws IOException {
        if (!casInputStream.markSupported()) {
            casInputStream = new BufferedInputStream(casInputStream);
        }
        CASImpl casImpl = (CASImpl)aCAS;
        BinaryCasSerDes bcsd = casImpl.getBinaryCasSerDes();
        casInputStream.mark(9);
        byte[] firstPartOfFile = new byte[9];
        int bytesReadCount = casInputStream.read(firstPartOfFile);
        casInputStream.reset();
        String start = new String(firstPartOfFile, 0, bytesReadCount, StandardCharsets.UTF_8).toLowerCase();
        if (start.startsWith("<?xml ") || start.startsWith("<xmi:xmi ")) {
            try {
                bcsd.setupCasFromCasMgrSerializer(CasIOUtils.readCasManager(tsiInputStream));
                return XmlCasDeserializer.deserializeR(casInputStream, aCAS, casLoadMode == CasLoadMode.LENIENT);
            }
            catch (SAXException e) {
                throw new UIMARuntimeException(e);
            }
        }
        DataInputStream deserIn = CommonSerDes.maybeWrapToDataInputStream(casInputStream);
        if (CommonSerDes.isBinaryHeader(deserIn)) {
            CommonSerDes.Header h = CommonSerDes.readHeader(deserIn);
            return bcsd.reinit(h, casInputStream, CasIOUtils.readCasManager(tsiInputStream), casLoadMode, null, AllowPreexistingFS.allow, typeSystem);
        }
        try {
            Object o = SerializationUtils.deserializeCASSerializerOrCASCompleteSerializer(casInputStream);
            if (o instanceof CASSerializer) {
                bcsd.setupCasFromCasMgrSerializer(CasIOUtils.readCasManager(tsiInputStream));
                bcsd.reinit((CASSerializer)o);
                return SerialFormat.SERIALIZED;
            }
            if (o instanceof CASCompleteSerializer) {
                bcsd.reinit((CASCompleteSerializer)o);
                return SerialFormat.SERIALIZED_TSI;
            }
            throw new CASRuntimeException("UNRECOGNIZED_SERIALIZED_CAS_FORMAT", new Object[0]);
        }
        catch (IOException e) {
            throw new CASRuntimeException("UNRECOGNIZED_SERIALIZED_CAS_FORMAT", new Object[0]);
        }
    }

    public static void save(CAS aCas, OutputStream docOS, SerialFormat format) throws IOException {
        CasIOUtils.save(aCas, docOS, null, format);
    }

    public static void save(CAS aCas, OutputStream docOS, OutputStream tsiOS, SerialFormat format) throws IOException {
        boolean typeSystemWritten = false;
        try {
            switch (format) {
                case XMI: {
                    XmiCasSerializer.serialize(aCas, docOS);
                    break;
                }
                case XMI_PRETTY: {
                    XmiCasSerializer.serialize(aCas, null, docOS, true, null, null, false);
                    break;
                }
                case XMI_1_1: {
                    XmiCasSerializer.serialize(aCas, null, docOS, false, null, null, true);
                    break;
                }
                case XMI_1_1_PRETTY: {
                    XmiCasSerializer.serialize(aCas, null, docOS, true, null, null, true);
                    break;
                }
                case XCAS: {
                    XCASSerializer.serialize(aCas, docOS, true);
                    break;
                }
                case XCAS_1_1: {
                    XCASSerializer.serialize(aCas, docOS, true, true);
                    break;
                }
                case SERIALIZED: {
                    CasIOUtils.writeJavaObject(Serialization.serializeCAS(aCas), docOS);
                    break;
                }
                case SERIALIZED_TSI: {
                    CasIOUtils.writeJavaObject(Serialization.serializeCASComplete((CASMgr)((Object)aCas)), docOS);
                    typeSystemWritten = true;
                    break;
                }
                case BINARY: {
                    Serialization.serializeCAS(aCas, docOS);
                    break;
                }
                case BINARY_TSI: {
                    CASSerializer ser = new CASSerializer();
                    ser.addCAS((CASImpl)aCas, docOS, true);
                    break;
                }
                case COMPRESSED: {
                    Serialization.serializeWithCompression(aCas, docOS);
                    break;
                }
                case COMPRESSED_TSI: {
                    new BinaryCasSerDes4((TypeSystemImpl)aCas.getTypeSystem(), false).serializeWithTsi((CASImpl)aCas, docOS);
                    break;
                }
                case COMPRESSED_FILTERED: {
                    Serialization.serializeWithCompression(aCas, docOS, false, false);
                    break;
                }
                case COMPRESSED_FILTERED_TS: {
                    Serialization.serializeWithCompression(aCas, docOS, true, false);
                    typeSystemWritten = true;
                    break;
                }
                case COMPRESSED_FILTERED_TSI: {
                    Serialization.serializeWithCompression(aCas, docOS, false, true);
                    typeSystemWritten = true;
                    break;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    for (SerialFormat sf : SerialFormat.values()) {
                        sb = sb.append(sf.toString()).append(", ");
                    }
                    throw new IllegalArgumentException("Unknown format [" + format.name() + "]. Must be one of: " + sb.toString());
                }
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (tsiOS != null && !typeSystemWritten) {
            CasIOUtils.writeTypeSystem(aCas, tsiOS, true);
        }
    }

    private static CASMgrSerializer readCasManager(InputStream tsiInputStream) throws IOException {
        if (null == tsiInputStream) {
            return null;
        }
        return SerializationUtils.deserializeCASMgrSerializer(tsiInputStream);
    }

    private static void writeJavaObject(Object o, OutputStream aOS) throws IOException {
        ObjectOutputStream tsiOS = new ObjectOutputStream(aOS);
        tsiOS.writeObject(o);
        tsiOS.flush();
    }

    public static void writeTypeSystem(CAS aCas, OutputStream aOS, boolean includeIndexDefs) throws IOException {
        CasIOUtils.writeJavaObject(includeIndexDefs ? Serialization.serializeCASMgr((CASImpl)aCas) : Serialization.serializeCASMgrTypeSystemOnly((CASImpl)aCas), aOS);
    }
}

