/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.flow.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.FlowConstraints;
import org.apache.uima.cas.CAS;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;

public class FixedFlowController
extends CasFlowController_ImplBase {
    public static final String PARAM_ACTION_AFTER_CAS_MULTIPLIER = "ActionAfterCasMultiplier";
    private static final int ACTION_CONTINUE = 0;
    private static final int ACTION_STOP = 1;
    private static final int ACTION_DROP = 2;
    private static final int ACTION_DROP_IF_NEW_CAS_PRODUCED = 3;
    private final List<String> mSequence = new CopyOnWriteArrayList<String>();
    private int mActionAfterCasMultiplier;

    @Override
    public synchronized void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        ArrayList<String> keysToAdd;
        if (this.getContext() == aContext) {
            return;
        }
        this.mSequence.clear();
        super.initialize(aContext);
        FlowConstraints flowConstraints = aContext.getAggregateMetadata().getFlowConstraints();
        if (flowConstraints instanceof FixedFlow) {
            String[] sequence = ((FixedFlow)flowConstraints).getFixedFlow();
            keysToAdd = new ArrayList<String>(sequence.length);
            for (String key : sequence) {
                if (!aContext.getAnalysisEngineMetaDataMap().containsKey(key)) {
                    throw new ResourceInitializationException("flow_controller_missing_delegate", new Object[]{this.getClass().getName(), key, aContext.getAggregateMetadata().getSourceUrlString()});
                }
                keysToAdd.add(key);
            }
        } else {
            throw new ResourceInitializationException("flow_controller_requires_flow_constraints", new Object[]{this.getClass().getName(), "fixedFlow", aContext.getAggregateMetadata().getSourceUrlString()});
        }
        this.mSequence.addAll(keysToAdd);
        String actionAfterCasMultiplier = (String)aContext.getConfigParameterValue(PARAM_ACTION_AFTER_CAS_MULTIPLIER);
        if ("continue".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 0;
        } else if ("stop".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 1;
        } else if ("drop".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 2;
        } else if ("dropIfNewCasProduced".equalsIgnoreCase(actionAfterCasMultiplier)) {
            this.mActionAfterCasMultiplier = 3;
        } else if (actionAfterCasMultiplier == null) {
            this.mActionAfterCasMultiplier = 3;
        } else {
            throw new ResourceInitializationException("invalid_action_after_cas_multiplier", new Object[]{actionAfterCasMultiplier});
        }
    }

    @Override
    public Flow computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        return new FixedFlowObject(0);
    }

    @Override
    public void addAnalysisEngines(Collection<String> aKeys) {
        this.mSequence.addAll(aKeys);
    }

    @Override
    public void removeAnalysisEngines(Collection<String> aKeys) throws AnalysisEngineProcessException {
        this.mSequence.removeAll(aKeys);
    }

    public static FlowControllerDescription getDescription() {
        FlowControllerDescription desc = UIMAFramework.getResourceSpecifierFactory().createFlowControllerDescription();
        desc.setImplementationName(FixedFlowController.class.getName());
        ProcessingResourceMetaData metaData = desc.getFlowControllerMetaData();
        metaData.setName("Fixed Flow Controller");
        metaData.setDescription("Simple FlowController that uses the FixedFlow element of the\n\t\taggregate descriptor to determine a linear flow.");
        metaData.setVendor("The Apache Software Foundation");
        metaData.setVersion("1.0");
        Capability capability = UIMAFramework.getResourceSpecifierFactory().createCapability();
        metaData.setCapabilities(capability);
        ConfigurationParameter param = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameter();
        param.setName(PARAM_ACTION_AFTER_CAS_MULTIPLIER);
        param.setType("String");
        param.setDescription("The action to be taken after a CAS has been input to a CAS Multiplier and the CAS Multiplier has finished processing it.\n\t\t Valid values are:\n\t\t\tcontinue - the CAS continues on to the next element in the flow\n\t\t\tstop - the CAS will no longer continue in the flow, and will be returned from the aggregate if possible.\n\t\t\tdrop - the CAS will no longer continue in the flow, and will be dropped (not returned from the aggregate) if possible.\t \n\t\t\tdropIfNewCasProduced (the default) - if the CAS multiplier produced a new CAS as a result of processing this CAS, then this\n\t\t\t\tCAS will be dropped.  If not, then this CAS will continue.");
        ConfigurationParameterDeclarations parameterDeclarations = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameterDeclarations();
        parameterDeclarations.setConfigurationParameters(param);
        metaData.setConfigurationParameterDeclarations(parameterDeclarations);
        NameValuePair paramSetting = UIMAFramework.getResourceSpecifierFactory().createNameValuePair();
        paramSetting.setName(PARAM_ACTION_AFTER_CAS_MULTIPLIER);
        paramSetting.setValue("dropIfNewCasProduced");
        ConfigurationParameterSettings parameterSettings = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameterSettings();
        parameterSettings.setParameterSettings(paramSetting);
        metaData.setConfigurationParameterSettings(parameterSettings);
        return desc;
    }

    public static FlowControllerDescription makeDefaultDescription() {
        FlowControllerDescription desc = UIMAFramework.getResourceSpecifierFactory().createFlowControllerDescription();
        desc.setImplementationName(FixedFlowController.class.getName());
        ProcessingResourceMetaData metaData = desc.getFlowControllerMetaData();
        metaData.setName("Fixed Flow Controller");
        metaData.setDescription("Simple FlowController that uses the FixedFlow element of the\n\t\taggregate descriptor to determine a linear flow.");
        metaData.setVendor("The Apache Software Foundation");
        metaData.setVersion("1.0");
        Capability capability = UIMAFramework.getResourceSpecifierFactory().createCapability();
        metaData.setCapabilities(capability);
        ConfigurationParameter param = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameter();
        param.setName(PARAM_ACTION_AFTER_CAS_MULTIPLIER);
        param.setType("String");
        param.setDescription("The action to be taken after a CAS has been input to a CAS Multiplier and the CAS Multiplier has finished processing it.\n\t\t Valid values are:\n\t\t\tcontinue - the CAS continues on to the next element in the flow\n\t\t\tstop - the CAS will no longer continue in the flow, and will be returned from the aggregate if possible.\n\t\t\tdrop - the CAS will no longer continue in the flow, and will be dropped (not returned from the aggregate) if possible.\t \n\t\t\tdropIfNewCasProduced (the default) - if the CAS multiplier produced a new CAS as a result of processing this CAS, then this\n\t\t\t\tCAS will be dropped.  If not, then this CAS will continue.");
        ConfigurationParameterDeclarations parameterDecls = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameterDeclarations();
        parameterDecls.setConfigurationParameters(param);
        metaData.setConfigurationParameterDeclarations(parameterDecls);
        NameValuePair paramSetting = UIMAFramework.getResourceSpecifierFactory().createNameValuePair();
        paramSetting.setName(PARAM_ACTION_AFTER_CAS_MULTIPLIER);
        paramSetting.setValue("dropIfNewCasProduced");
        ConfigurationParameterSettings parameterSettings = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameterSettings();
        parameterSettings.setParameterSettings(paramSetting);
        metaData.setConfigurationParameterSettings(parameterSettings);
        return desc;
    }

    class FixedFlowObject
    extends CasFlow_ImplBase {
        private int currentStep;
        private boolean wasPassedToCasMultiplier = false;
        private boolean casMultiplierProducedNewCas = false;
        private boolean internallyCreatedCas = false;

        public FixedFlowObject(int startStep) {
            this(startStep, false);
        }

        public FixedFlowObject(int aStartStep, boolean aInternallyCreatedCas) {
            this.currentStep = aStartStep;
            this.internallyCreatedCas = aInternallyCreatedCas;
        }

        @Override
        public Step next() throws AnalysisEngineProcessException {
            if (this.wasPassedToCasMultiplier) {
                switch (FixedFlowController.this.mActionAfterCasMultiplier) {
                    case 1: {
                        return new FinalStep();
                    }
                    case 2: {
                        return new FinalStep(this.internallyCreatedCas);
                    }
                    case 3: {
                        if (!this.casMultiplierProducedNewCas) break;
                        return new FinalStep(this.internallyCreatedCas);
                    }
                }
                this.wasPassedToCasMultiplier = false;
                this.casMultiplierProducedNewCas = false;
            }
            if (this.currentStep >= FixedFlowController.this.mSequence.size()) {
                return new FinalStep();
            }
            AnalysisEngineMetaData md = FixedFlowController.this.getContext().getAnalysisEngineMetaDataMap().get(FixedFlowController.this.mSequence.get(this.currentStep));
            if (md.getOperationalProperties().getOutputsNewCASes()) {
                this.wasPassedToCasMultiplier = true;
            }
            return new SimpleStep(FixedFlowController.this.mSequence.get(this.currentStep++));
        }

        @Override
        public Flow newCasProduced(CAS newCas, String producedBy) throws AnalysisEngineProcessException {
            this.casMultiplierProducedNewCas = true;
            int i = 0;
            while (!FixedFlowController.this.mSequence.get(i).equals(producedBy)) {
                ++i;
            }
            return new FixedFlowObject(i + 1, true);
        }
    }
}

