/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.util.Map;
import org.apache.uima.ResourceFactory;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.analysis_engine.impl.AggregateAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.MultiprocessingAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.PrimitiveAnalysisEngine_impl;
import org.apache.uima.analysis_engine.impl.UimacppAnalysisEngineImpl;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;

public class AnalysisEngineFactory_impl
implements ResourceFactory {
    @Override
    public Resource produceResource(Class<? extends Resource> aResourceClass, ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        boolean multiprocessing = aAdditionalParams != null && aAdditionalParams.containsKey("NUM_SIMULTANEOUS_REQUESTS");
        Resource resource = null;
        if (aSpecifier instanceof ResourceCreationSpecifier) {
            ResourceCreationSpecifier spec = (ResourceCreationSpecifier)aSpecifier;
            if (aResourceClass.isAssignableFrom(TextAnalysisEngine.class)) {
                if (multiprocessing) {
                    resource = new MultiprocessingAnalysisEngine_impl();
                } else {
                    String frameworkImpl = spec.getFrameworkImplementation();
                    if (frameworkImpl == null || frameworkImpl.isEmpty()) {
                        throw new ResourceInitializationException("missing_framework_implementation", new Object[]{aSpecifier.getSourceUrlString()});
                    }
                    if (frameworkImpl.startsWith("org.apache.uima.cpp")) {
                        resource = new UimacppAnalysisEngineImpl();
                    } else if (frameworkImpl.startsWith("org.apache.uima.java")) {
                        AnalysisEngineDescription aeSpec;
                        resource = spec instanceof AnalysisEngineDescription && !(aeSpec = (AnalysisEngineDescription)spec).isPrimitive() ? new AggregateAnalysisEngine_impl() : new PrimitiveAnalysisEngine_impl();
                    } else {
                        throw new ResourceInitializationException("unsupported_framework_implementation", new Object[]{spec.getFrameworkImplementation(), aSpecifier.getSourceUrlString()});
                    }
                }
            }
        }
        if (resource != null && resource.initialize(aSpecifier, aAdditionalParams)) {
            return resource;
        }
        return null;
    }
}

