/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci.util;

import java.util.Stack;
import org.apache.vinci.transport.Attributes;
import org.apache.vinci.transport.document.AFrame;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxVinciFrameBuilder
extends DefaultHandler
implements ContentHandler {
    private Stack<AFrame> mOpenFrames;
    private String mCurrentFrameName;
    private org.xml.sax.Attributes mCurrentFrameAttrs;
    private StringBuffer mCharContentBuffer;

    public void setParentFrame(AFrame aParentFrame) {
        this.mOpenFrames = new Stack();
        this.mOpenFrames.push(aParentFrame);
    }

    @Override
    public void startDocument() throws SAXException {
        this.mCurrentFrameName = null;
        this.mCurrentFrameAttrs = null;
        this.mCharContentBuffer = new StringBuffer();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qualifiedName, org.xml.sax.Attributes attributes) throws SAXException {
        String elemName;
        if (this.mCurrentFrameName != null) {
            AFrame frame = new AFrame();
            AFrame parent = this.mOpenFrames.peek();
            Attributes vinciAttrs = parent.aadd(this.mCurrentFrameName, frame);
            if (this.mCurrentFrameAttrs != null) {
                for (int i = 0; i < this.mCurrentFrameAttrs.getLength(); ++i) {
                    String attrName = this.getName(this.mCurrentFrameAttrs.getLocalName(i), this.mCurrentFrameAttrs.getQName(i));
                    vinciAttrs.fadd(attrName, this.mCurrentFrameAttrs.getValue(i));
                }
            }
            this.mOpenFrames.push(frame);
        }
        this.mCurrentFrameName = elemName = this.getName(localName, qualifiedName);
        this.mCurrentFrameAttrs = attributes;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.mCharContentBuffer.append(ch, start, length);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        if (this.mCurrentFrameName != null) {
            String leafContent = this.getLeafContent(this.mCurrentFrameName, this.mCurrentFrameAttrs, this.mCharContentBuffer);
            AFrame parent = this.mOpenFrames.peek();
            Attributes vinciAttrs = parent.aadd(this.mCurrentFrameName, leafContent);
            if (this.mCurrentFrameAttrs != null) {
                for (int i = 0; i < this.mCurrentFrameAttrs.getLength(); ++i) {
                    String attrName = this.getName(this.mCurrentFrameAttrs.getLocalName(i), this.mCurrentFrameAttrs.getQName(i));
                    vinciAttrs.fadd(attrName, this.mCurrentFrameAttrs.getValue(i));
                }
            }
            this.mCurrentFrameName = null;
            this.mCurrentFrameAttrs = null;
            this.mCharContentBuffer = new StringBuffer();
        } else {
            this.mOpenFrames.pop();
        }
    }

    protected String getLeafContent(String aFrameName, org.xml.sax.Attributes aAttributes, StringBuffer aContentBuf) {
        return aContentBuf.toString();
    }

    protected String getName(String s1, String s2) {
        if (s1 == null || "".equals(s1)) {
            return s2;
        }
        return s1;
    }
}

