/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.PluginType;
import org.apache.unomi.api.PropertyMergeStrategyType;
import org.apache.unomi.api.ValueType;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.rest.LocalizationHelper;
import org.apache.unomi.rest.RESTActionType;
import org.apache.unomi.rest.RESTConditionType;
import org.apache.unomi.rest.RESTValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json;charset=UTF-8"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
public class DefinitionsServiceEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)DefinitionsServiceEndPoint.class.getName());
    private DefinitionsService definitionsService;
    private LocalizationHelper localizationHelper;

    @WebMethod(exclude=true)
    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    @WebMethod(exclude=true)
    public void setLocalizationHelper(LocalizationHelper localizationHelper) {
        this.localizationHelper = localizationHelper;
    }

    @GET
    @Path(value="/conditions")
    public Collection<RESTConditionType> getAllConditionTypes(@HeaderParam(value="Accept-Language") String language) {
        Collection conditionTypes = this.definitionsService.getAllConditionTypes();
        return this.localizationHelper.generateConditions(conditionTypes, language);
    }

    @GET
    @Path(value="/conditions/tags/{tags}")
    public Collection<RESTConditionType> getConditionTypesByTag(@PathParam(value="tags") String tags, @HeaderParam(value="Accept-Language") String language) {
        String[] tagsArray = tags.split(",");
        LinkedHashSet<ConditionType> results = new LinkedHashSet<ConditionType>();
        for (String tag : tagsArray) {
            results.addAll(this.definitionsService.getConditionTypesByTag(tag));
        }
        return this.localizationHelper.generateConditions(results, language);
    }

    @GET
    @Path(value="/conditions/systemTags/{tags}")
    public Collection<RESTConditionType> getConditionTypesBySystemTag(@PathParam(value="tags") String tags, @HeaderParam(value="Accept-Language") String language) {
        String[] tagsArray = tags.split(",");
        LinkedHashSet<ConditionType> results = new LinkedHashSet<ConditionType>();
        for (String tag : tagsArray) {
            results.addAll(this.definitionsService.getConditionTypesBySystemTag(tag));
        }
        return this.localizationHelper.generateConditions(results, language);
    }

    @GET
    @Path(value="/conditions/{conditionId}")
    public RESTConditionType getConditionType(@PathParam(value="conditionId") String id, @HeaderParam(value="Accept-Language") String language) {
        ConditionType conditionType = this.definitionsService.getConditionType(id);
        return conditionType != null ? this.localizationHelper.generateCondition(conditionType, language) : null;
    }

    @POST
    @Path(value="/conditions")
    public void setConditionType(ConditionType conditionType) {
        this.definitionsService.setConditionType(conditionType);
    }

    @DELETE
    @Path(value="/conditions/{conditionTypeId}")
    public void removeConditionType(@PathParam(value="conditionTypeId") String conditionTypeId) {
        this.definitionsService.removeConditionType(conditionTypeId);
    }

    @GET
    @Path(value="/actions")
    public Collection<RESTActionType> getAllActionTypes(@HeaderParam(value="Accept-Language") String language) {
        Collection actionTypes = this.definitionsService.getAllActionTypes();
        return this.localizationHelper.generateActions(actionTypes, language);
    }

    @GET
    @Path(value="/actions/tags/{tags}")
    public Collection<RESTActionType> getActionTypeByTag(@PathParam(value="tags") String tags, @HeaderParam(value="Accept-Language") String language) {
        String[] tagsArray = tags.split(",");
        LinkedHashSet<ActionType> results = new LinkedHashSet<ActionType>();
        for (String tag : tagsArray) {
            results.addAll(this.definitionsService.getActionTypeByTag(tag));
        }
        return this.localizationHelper.generateActions(results, language);
    }

    @GET
    @Path(value="/actions/systemTags/{tags}")
    public Collection<RESTActionType> getActionTypeBySystemTag(@PathParam(value="tags") String tags, @HeaderParam(value="Accept-Language") String language) {
        String[] tagsArray = tags.split(",");
        LinkedHashSet<ActionType> results = new LinkedHashSet<ActionType>();
        for (String tag : tagsArray) {
            results.addAll(this.definitionsService.getActionTypeBySystemTag(tag));
        }
        return this.localizationHelper.generateActions(results, language);
    }

    @GET
    @Path(value="/actions/{actionId}")
    public RESTActionType getActionType(@PathParam(value="actionId") String id, @HeaderParam(value="Accept-Language") String language) {
        ActionType actionType = this.definitionsService.getActionType(id);
        return actionType != null ? this.localizationHelper.generateAction(actionType, language) : null;
    }

    @POST
    @Path(value="/actions")
    public void setActionType(ActionType actionType) {
        this.definitionsService.setActionType(actionType);
    }

    @DELETE
    @Path(value="/actions/{actionTypeId}")
    public void removeActionType(@PathParam(value="actionTypeId") String actionTypeId) {
        this.definitionsService.removeActionType(actionTypeId);
    }

    @GET
    @Path(value="/values")
    public Collection<RESTValueType> getAllValueTypes(@HeaderParam(value="Accept-Language") String language) {
        return this.localizationHelper.generateValueTypes(this.definitionsService.getAllValueTypes(), language);
    }

    @GET
    @Path(value="/values/tags/{tags}")
    public Collection<RESTValueType> getValueTypeByTag(@PathParam(value="tags") String tags, @HeaderParam(value="Accept-Language") String language) {
        String[] tagsArray = tags.split(",");
        LinkedHashSet<ValueType> results = new LinkedHashSet<ValueType>();
        for (String tag : tagsArray) {
            results.addAll(this.definitionsService.getValueTypeByTag(tag));
        }
        return this.localizationHelper.generateValueTypes(results, language);
    }

    @GET
    @Path(value="/values/{valueTypeId}")
    public RESTValueType getValueType(@PathParam(value="valueTypeId") String id, @HeaderParam(value="Accept-Language") String language) {
        ValueType valueType = this.definitionsService.getValueType(id);
        return this.localizationHelper.generateValueType(valueType, language);
    }

    @GET
    @Path(value="/typesByPlugin")
    public Map<Long, List<PluginType>> getTypesByPlugin() {
        return this.definitionsService.getTypesByPlugin();
    }

    @WebMethod(exclude=true)
    public PropertyMergeStrategyType getPropertyMergeStrategyType(String id) {
        return this.definitionsService.getPropertyMergeStrategyType(id);
    }
}

