/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.api;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Item
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger((String)Item.class.getName());
    private static final long serialVersionUID = 7446061538573517071L;
    private static final Map<Class, String> itemTypeCache = new ConcurrentHashMap<Class, String>();
    protected String itemId;
    protected String itemType = Item.getItemType(this.getClass());
    protected String scope;
    protected Long version;

    public static String getItemType(Class clazz) {
        String itemType = itemTypeCache.get(clazz);
        if (itemType != null) {
            return itemType;
        }
        try {
            itemType = (String)clazz.getField("ITEM_TYPE").get(null);
            itemTypeCache.put(clazz, itemType);
            return itemType;
        }
        catch (NoSuchFieldException e) {
            logger.error("Class " + clazz.getName() + " doesn't define a publicly accessible ITEM_TYPE field", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error resolving itemType for class " + clazz.getName(), (Throwable)e);
        }
        return null;
    }

    public Item() {
        if (this.itemType == null) {
            logger.error("Item implementations must provide a public String constant named ITEM_TYPE to uniquely identify this Item for the persistence service.");
        }
    }

    public Item(String itemId) {
        this();
        this.itemId = itemId;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return !(this.itemId == null ? item.itemId != null : !this.itemId.equals(item.itemId));
    }

    public int hashCode() {
        return this.itemId != null ? this.itemId.hashCode() : 0;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
}

