/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHelper {
    private static final Logger logger = LoggerFactory.getLogger((String)PropertyHelper.class.getName());
    private static DefaultResolver resolver = new DefaultResolver();

    public static boolean setProperty(Object target, String propertyName, Object propertyValue, String setPropertyStrategy) {
        try {
            if (setPropertyStrategy != null && setPropertyStrategy.equals("remove")) {
                if (resolver.hasNested(propertyName)) {
                    String parentPropertyName = propertyName.substring(0, propertyName.lastIndexOf(46));
                    try {
                        Object parentPropertyValue = PropertyUtils.getNestedProperty(target, (String)parentPropertyName);
                        if (parentPropertyValue instanceof HashMap) {
                            if (((HashMap)parentPropertyValue).keySet().contains(propertyName.substring(propertyName.lastIndexOf(46) + 1))) {
                                ((HashMap)parentPropertyValue).remove(propertyName.substring(propertyName.lastIndexOf(46) + 1));
                                PropertyUtils.setNestedProperty(target, (String)parentPropertyName, (Object)parentPropertyValue);
                                return true;
                            }
                            return false;
                        }
                    }
                    catch (NestedNullException ex) {
                        return false;
                    }
                }
                return false;
            }
            while (resolver.hasNested(propertyName)) {
                LinkedHashMap v = PropertyUtils.getProperty((Object)target, (String)resolver.next(propertyName));
                if (v == null) {
                    v = new LinkedHashMap();
                    PropertyUtils.setProperty(target, (String)resolver.next(propertyName), v);
                }
                propertyName = resolver.remove(propertyName);
                target = v;
            }
            if (setPropertyStrategy != null && setPropertyStrategy.equals("addValue")) {
                Object previousValue = PropertyUtils.getProperty((Object)target, (String)propertyName);
                ArrayList<Object> values = new ArrayList<Object>();
                if (previousValue != null && previousValue instanceof List) {
                    values.addAll((List)previousValue);
                } else if (previousValue != null) {
                    values.add(previousValue);
                }
                if (!values.contains(propertyValue)) {
                    values.add(propertyValue);
                    BeanUtils.setProperty(target, (String)propertyName, values);
                    return true;
                }
            }
            if (setPropertyStrategy != null && setPropertyStrategy.equals("addValues")) {
                Object newValues = propertyValue;
                List<Object> newValuesList = PropertyHelper.convertToList(newValues);
                Object previousValue = PropertyUtils.getProperty(target, (String)propertyName);
                List<Object> previousValueList = PropertyHelper.convertToList(previousValue);
                newValuesList.addAll(previousValueList);
                HashSet<Object> propertiesSet = new HashSet<Object>(newValuesList);
                List<Object> propertiesList = Arrays.asList(propertiesSet.toArray());
                BeanUtils.setProperty(target, (String)propertyName, propertiesList);
                return true;
            }
            if (propertyValue != null && !PropertyHelper.compareValues(propertyValue, BeanUtils.getProperty((Object)target, (String)propertyName)) && (setPropertyStrategy == null || setPropertyStrategy.equals("alwaysSet") || setPropertyStrategy.equals("setIfMissing") && BeanUtils.getProperty(target, (String)propertyName) == null)) {
                BeanUtils.setProperty(target, (String)propertyName, (Object)propertyValue);
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("Cannot set property", (Throwable)e);
        }
        return false;
    }

    public static List<Object> convertToList(Object value) {
        ArrayList<Object> convertedList = new ArrayList<Object>();
        if (value != null && value instanceof List) {
            convertedList.addAll((List)value);
        } else if (value != null) {
            convertedList.add(value);
        }
        return convertedList;
    }

    public static Integer getInteger(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double getDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Boolean getBooleanValue(Object setPropertyValueBoolean) {
        if (setPropertyValueBoolean instanceof Boolean) {
            return (Boolean)setPropertyValueBoolean;
        }
        if (setPropertyValueBoolean instanceof Number) {
            if (((Number)setPropertyValueBoolean).intValue() >= 1) {
                return new Boolean(true);
            }
            return new Boolean(false);
        }
        if (((String)setPropertyValueBoolean).equalsIgnoreCase("true") || ((String)setPropertyValueBoolean).equalsIgnoreCase("on") || ((String)setPropertyValueBoolean).equalsIgnoreCase("yes") || ((String)setPropertyValueBoolean).equalsIgnoreCase("1")) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    public static Object getValueByTypeId(Object propertyValue, String valueTypeId) {
        if ("boolean".equals(valueTypeId)) {
            return PropertyHelper.getBooleanValue(propertyValue);
        }
        if ("integer".equals(valueTypeId)) {
            return PropertyHelper.getInteger(propertyValue);
        }
        return propertyValue;
    }

    public static boolean compareValues(Object propertyValue, Object beanPropertyValue) {
        if (propertyValue == null) {
            return true;
        }
        if (beanPropertyValue == null) {
            return false;
        }
        if (propertyValue instanceof Integer) {
            return propertyValue.equals(PropertyHelper.getInteger(beanPropertyValue));
        }
        if (propertyValue instanceof Boolean) {
            return propertyValue.equals(PropertyHelper.getBooleanValue(beanPropertyValue));
        }
        return propertyValue.equals(beanPropertyValue);
    }

    public static Map<String, Object> flatten(Map<String, Object> in) {
        return in.entrySet().stream().filter(entry -> entry.getValue() != null).flatMap(entry -> PropertyHelper.flatten(entry).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Object> flatten(Map.Entry<String, Object> in) {
        if (!Map.class.isInstance(in.getValue())) {
            return Collections.singletonMap(in.getKey(), in.getValue());
        }
        String prefix = in.getKey();
        Map values = (Map)in.getValue();
        HashMap<String, Object> flattenMap = new HashMap<String, Object>();
        values.keySet().forEach(key -> flattenMap.put(prefix + "." + key, values.get(key)));
        return PropertyHelper.flatten(flattenMap);
    }
}

