/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.RemovePropertiesProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,transformation")
@XmlRootElement(name="removeProperties")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RemovePropertiesDefinition
extends NoOutputDefinition<RemovePropertiesDefinition> {
    @XmlAttribute(required=true)
    private String pattern;
    @XmlAttribute
    private String excludePattern;
    @XmlTransient
    private String[] excludePatterns;

    public RemovePropertiesDefinition() {
    }

    public RemovePropertiesDefinition(String pattern) {
        this.setPattern(pattern);
    }

    public RemovePropertiesDefinition(String pattern, String ... excludePatterns) {
        this.setPattern(pattern);
        this.setExcludePatterns(excludePatterns);
    }

    public String toString() {
        return "removeProperties[" + this.getPattern() + "]";
    }

    @Override
    public String getLabel() {
        return "removeProperties[" + this.getPattern() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notNull(this.getPattern(), "patterns", this);
        if (this.getExcludePatterns() != null) {
            return new RemovePropertiesProcessor(this.getPattern(), this.getExcludePatterns());
        }
        if (this.getExcludePattern() != null) {
            return new RemovePropertiesProcessor(this.getPattern(), new String[]{this.getExcludePattern()});
        }
        return new RemovePropertiesProcessor(this.getPattern(), null);
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String[] getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public void setExcludePattern(String excludePattern) {
        this.excludePattern = excludePattern;
    }
}

