/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.FactoryFinder;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SAAJMetaFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class MessageFactory {
    public static MessageFactory newInstance() throws SOAPException {
        try {
            MessageFactory factory = (MessageFactory)FactoryFinder.find(MessageFactory.class, null);
            if (factory == null) {
                factory = MessageFactory.newInstance("SOAP 1.1 Protocol");
            }
            return factory;
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to create MessageFactory: " + exception.getMessage());
        }
    }

    public abstract SOAPMessage createMessage() throws SOAPException;

    public abstract SOAPMessage createMessage(MimeHeaders var1, InputStream var2) throws IOException, SOAPException;

    public static MessageFactory newInstance(String soapVersion) throws SOAPException {
        return SAAJMetaFactory.getInstance().newMessageFactory(soapVersion);
    }
}

