/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.shell.commands.ListCommandSupport;

@Command(scope="unomi", name="session-list", description="This commands lists the latest sessions updated in the Apache Unomi Context Server")
@Service
public class SessionList
extends ListCommandSupport {
    @Reference
    ProfileService profileService;
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="maxEntries", description="The maximum number of entries to retrieve (defaults to 100)", required=false, multiValued=false)
    int maxEntries = 100;

    @Override
    protected String[] getHeaders() {
        return new String[]{"ID", "Scope", "Last event", "Duration", "Profile", "Timestamp"};
    }

    @Override
    protected DataTable buildDataTable() {
        Query query = new Query();
        query.setSortby("lastEventDate:desc");
        query.setLimit(this.maxEntries);
        Condition matchAllCondition = new Condition(this.definitionsService.getConditionType("matchAllCondition"));
        query.setCondition(matchAllCondition);
        PartialList lastModifiedProfiles = this.profileService.searchSessions(query);
        DataTable dataTable = new DataTable();
        for (Session session : lastModifiedProfiles.getList()) {
            ArrayList<Object> rowData = new ArrayList<Object>();
            rowData.add(session.getItemId());
            rowData.add(session.getScope());
            rowData.add(session.getLastEventDate());
            rowData.add(session.getDuration());
            rowData.add(session.getProfileId());
            rowData.add(session.getTimeStamp());
            dataTable.addRow(rowData.toArray(new Comparable[rowData.size()]));
        }
        return dataTable;
    }
}

