/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Member;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.utils.CombinedClassLoader;
import org.apache.karaf.cellar.hazelcast.HazelcastInstanceAware;
import org.apache.karaf.cellar.hazelcast.HazelcastNode;
import org.osgi.service.cm.ConfigurationAdmin;

public class HazelcastClusterManager
extends HazelcastInstanceAware
implements ClusterManager {
    private static final String GENERATOR_ID = "org.apache.karaf.cellar.idgen";
    private IdGenerator idgenerator;
    private ConfigurationAdmin configurationAdmin;
    private CombinedClassLoader combinedClassLoader;

    public Map getMap(String mapName) {
        return this.instance.getMap(mapName);
    }

    public List getList(String listName) {
        return this.instance.getList(listName);
    }

    public Set getSet(String setName) {
        return this.instance.getSet(setName);
    }

    public Set<Node> listNodes() {
        Set members;
        HashSet<Node> nodes = new HashSet<Node>();
        Cluster cluster = this.instance.getCluster();
        if (cluster != null && (members = cluster.getMembers()) != null && !members.isEmpty()) {
            for (Member member : members) {
                HazelcastNode node = new HazelcastNode(member);
                nodes.add(node);
            }
        }
        return nodes;
    }

    public Set<Node> listNodes(Collection<String> ids) {
        Set members;
        Cluster cluster;
        HashSet<Node> nodes = new HashSet<Node>();
        if (ids != null && !ids.isEmpty() && (cluster = this.instance.getCluster()) != null && (members = cluster.getMembers()) != null && !members.isEmpty()) {
            for (Member member : members) {
                HazelcastNode node = new HazelcastNode(member);
                if (!ids.contains(node.getId())) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public Node findNodeById(String id) {
        Set members;
        Cluster cluster;
        if (id != null && (cluster = this.instance.getCluster()) != null && (members = cluster.getMembers()) != null && !members.isEmpty()) {
            for (Member member : members) {
                HazelcastNode node = new HazelcastNode(member);
                if (!id.equals(node.getId())) continue;
                return node;
            }
        }
        return null;
    }

    public Node findNodeByAlias(String alias) {
        Set members;
        Cluster cluster;
        if (alias != null && (cluster = this.instance.getCluster()) != null && (members = cluster.getMembers()) != null && !members.isEmpty()) {
            for (Member member : members) {
                HazelcastNode node = new HazelcastNode(member);
                if (!alias.equals(node.getAlias())) continue;
                return node;
            }
        }
        return null;
    }

    public Node findNodeByIdOrAlias(String idOrAlias) {
        Set members;
        Cluster cluster;
        if (idOrAlias != null && (cluster = this.instance.getCluster()) != null && (members = cluster.getMembers()) != null && !members.isEmpty()) {
            for (Member member : members) {
                HazelcastNode node = new HazelcastNode(member);
                if (idOrAlias.equals(node.getId())) {
                    return node;
                }
                if (!idOrAlias.equals(node.getAlias())) continue;
                return node;
            }
        }
        return null;
    }

    public Set<Node> listNodesByGroup(Group group) {
        return group.getNodes();
    }

    public synchronized String generateId() {
        if (this.idgenerator == null) {
            this.idgenerator = this.instance.getIdGenerator(GENERATOR_ID);
        }
        return String.valueOf(this.idgenerator.newId());
    }

    public void start() {
    }

    public void stop() {
        if (this.instance != null && this.instance.getLifecycleService().isRunning()) {
            this.instance.getLifecycleService().shutdown();
        }
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public CombinedClassLoader getCombinedClassLoader() {
        return this.combinedClassLoader;
    }

    public void setCombinedClassLoader(CombinedClassLoader combinedClassLoader) {
        this.combinedClassLoader = combinedClassLoader;
    }
}

