/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.ha;

import java.io.Closeable;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.file.ha.FileLockClusterService;
import org.apache.camel.ha.CamelClusterMember;
import org.apache.camel.impl.ha.AbstractCamelClusterView;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockClusterView
extends AbstractCamelClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLockClusterView.class);
    private final ClusterMember localMember = new ClusterMember();
    private final Path path;
    private RandomAccessFile file;
    private FileChannel channel;
    private FileLock lock;
    private ScheduledFuture<?> task;

    FileLockClusterView(FileLockClusterService cluster, String namespace) {
        super(cluster, namespace);
        this.path = Paths.get(cluster.getRoot(), namespace);
    }

    @Override
    public Optional<CamelClusterMember> getMaster() {
        return this.localMember.isLeader() ? Optional.of(this.localMember) : Optional.empty();
    }

    @Override
    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    @Override
    public List<CamelClusterMember> getMembers() {
        return Collections.emptyList();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.file != null) {
            this.close();
            this.fireLeadershipChangedEvent(Optional.empty());
        }
        if (!Files.exists(this.path.getParent(), new LinkOption[0])) {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        }
        this.file = new RandomAccessFile(this.path.toFile(), "rw");
        this.channel = this.file.getChannel();
        FileLockClusterService service = this.getClusterService().unwrap(FileLockClusterService.class);
        ScheduledExecutorService executor = service.getExecutor();
        this.task = executor.scheduleAtFixedRate(this::tryLock, TimeUnit.MILLISECONDS.convert(service.getAcquireLockDelay(), service.getAcquireLockDelayUnit()), TimeUnit.MILLISECONDS.convert(service.getAcquireLockInterval(), service.getAcquireLockIntervalUnit()), TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doStop() throws Exception {
        this.close();
    }

    private void close() throws Exception {
        if (this.task != null) {
            this.task.cancel(true);
        }
        if (this.lock != null) {
            this.lock.release();
        }
        if (this.file != null) {
            IOHelper.close((Closeable)this.channel);
            IOHelper.close((Closeable)this.file);
            this.channel = null;
            this.file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLock() {
        if (this.isStarting() || this.isStarted()) {
            try {
                if (this.localMember.isLeader()) {
                    LOGGER.trace("Holding the lock on file {} (lock={})", (Object)this.path, (Object)this.lock);
                    return;
                }
                FileLockClusterView fileLockClusterView = this;
                synchronized (fileLockClusterView) {
                    if (this.lock != null) {
                        LOGGER.info("Lock on file {} lost (lock={})", (Object)this.path, (Object)this.lock);
                        this.fireLeadershipChangedEvent(Optional.empty());
                    }
                    LOGGER.debug("Try to acquire a lock on {}", (Object)this.path);
                    this.lock = null;
                    this.lock = this.channel.tryLock();
                    if (this.lock != null) {
                        LOGGER.info("Lock on file {} acquired (lock={})", (Object)this.path, (Object)this.lock);
                        this.fireLeadershipChangedEvent(Optional.of(this.localMember));
                    } else {
                        LOGGER.debug("Lock on file {} not acquired ", (Object)this.path);
                    }
                }
            }
            catch (OverlappingFileLockException e) {
                LOGGER.debug("Lock on file {} not acquired ", (Object)this.path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class ClusterMember
    implements CamelClusterMember {
        private ClusterMember() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isLeader() {
            FileLockClusterView fileLockClusterView = FileLockClusterView.this;
            synchronized (fileLockClusterView) {
                return FileLockClusterView.this.lock != null && FileLockClusterView.this.lock.isValid();
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }

        @Override
        public String getId() {
            return FileLockClusterView.this.getClusterService().getId();
        }
    }
}

