/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanInfo;
import org.apache.camel.processor.aggregate.AggregationStrategyMethodInfo;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public final class AggregationStrategyBeanAdapter
extends ServiceSupport
implements AggregationStrategy,
CamelContextAware {
    private static final List<Method> EXCLUDED_METHODS = new ArrayList<Method>();
    private CamelContext camelContext;
    private Object pojo;
    private final Class<?> type;
    private String methodName;
    private boolean allowNullOldExchange;
    private boolean allowNullNewExchange;
    private volatile AggregationStrategyMethodInfo mi;

    public AggregationStrategyBeanAdapter(Object pojo) {
        this(pojo, null);
    }

    public AggregationStrategyBeanAdapter(Class<?> type) {
        this(type, null);
    }

    public AggregationStrategyBeanAdapter(Object pojo, String methodName) {
        this.pojo = pojo;
        this.type = pojo.getClass();
        this.methodName = methodName;
    }

    public AggregationStrategyBeanAdapter(Class<?> type, String methodName) {
        this.type = type;
        this.pojo = null;
        this.methodName = methodName;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public boolean isAllowNullOldExchange() {
        return this.allowNullOldExchange;
    }

    public void setAllowNullOldExchange(boolean allowNullOldExchange) {
        this.allowNullOldExchange = allowNullOldExchange;
    }

    public boolean isAllowNullNewExchange() {
        return this.allowNullNewExchange;
    }

    public void setAllowNullNewExchange(boolean allowNullNewExchange) {
        this.allowNullNewExchange = allowNullNewExchange;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (!this.allowNullOldExchange && oldExchange == null) {
            return newExchange;
        }
        if (!this.allowNullNewExchange && newExchange == null) {
            return oldExchange;
        }
        try {
            Object out = this.mi.invoke(this.pojo, oldExchange, newExchange);
            if (out != null) {
                if (oldExchange != null) {
                    oldExchange.getIn().setBody(out);
                } else {
                    newExchange.getIn().setBody(out);
                }
            }
        }
        catch (Exception e) {
            if (oldExchange != null) {
                oldExchange.setException(e);
            }
            newExchange.setException(e);
        }
        return oldExchange != null ? oldExchange : newExchange;
    }

    protected boolean isValidMethod(Method method) {
        for (Method excluded : EXCLUDED_METHODS) {
            if (!method.equals(excluded)) continue;
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        return !method.getReturnType().equals(Void.TYPE) && !method.isBridge();
    }

    private static boolean isStaticMethod(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    @Override
    protected void doStart() throws Exception {
        Method found = null;
        if (this.methodName != null) {
            for (Method method : this.type.getMethods()) {
                if (!this.isValidMethod(method) || !method.getName().equals(this.methodName)) continue;
                if (found == null) {
                    found = method;
                    continue;
                }
                throw new IllegalArgumentException("The bean " + this.type + " has 2 or more methods with the name " + this.methodName);
            }
        } else {
            for (Method method : this.type.getMethods()) {
                if (!this.isValidMethod(method)) continue;
                if (found == null) {
                    found = method;
                    continue;
                }
                throw new IllegalArgumentException("The bean " + this.type + " has 2 or more methods and no explicit method name was configured.");
            }
        }
        if (found == null) {
            throw new UnsupportedOperationException("Cannot find a valid method with name: " + this.methodName + " on bean type: " + this.type);
        }
        if (!AggregationStrategyBeanAdapter.isStaticMethod(found) && this.pojo == null) {
            this.pojo = this.camelContext.getInjector().newInstance(this.type);
        }
        AggregationStrategyBeanInfo bi = new AggregationStrategyBeanInfo(this.type, found);
        this.mi = bi.createMethodInfo();
        if (this.pojo != null && this.pojo instanceof CamelContextAware) {
            ((CamelContextAware)this.pojo).setCamelContext(this.getCamelContext());
        }
        ServiceHelper.startService(this.pojo);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.pojo);
    }

    static {
        EXCLUDED_METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        EXCLUDED_METHODS.addAll(Arrays.asList(Proxy.class.getMethods()));
    }
}

