/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(size);
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(int size) {
        return new HashSet(size);
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> c) {
        return new HashSet<T>(c);
    }

    public static <T> HashSet<T> newHashSet(Collection<? extends T> s1, Collection<? extends T> s2) {
        HashSet<T> set = CollectionHelper.newHashSet(s1);
        set.addAll(s2);
        return set;
    }

    public static <T> HashSet<T> newHashSet(Iterable<? extends T> iterable) {
        HashSet<T> set = CollectionHelper.newHashSet();
        for (T t : iterable) {
            set.add(t);
        }
        return set;
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int size) {
        return new ArrayList(size);
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(Iterable<T> ... iterables) {
        ArrayList<T> resultList = CollectionHelper.newArrayList();
        for (Iterable<T> oneIterable : iterables) {
            for (T oneElement : oneIterable) {
                resultList.add(oneElement);
            }
        }
        return resultList;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static <T> List<T> toImmutableList(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> Set<T> toImmutableSet(Set<T> set) {
        switch (set.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(set.iterator().next());
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static <K, V> Map<K, V> toImmutableMap(Map<K, V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, List<V>> partition(List<V> list, Partitioner<K, V> partitioner) {
        if (list == null) {
            return Collections.emptyMap();
        }
        HashMap theValue = CollectionHelper.newHashMap();
        for (V v : list) {
            K key = partitioner.getPartition(v);
            ArrayList partition = (ArrayList)theValue.get(key);
            if (partition == null) {
                partition = CollectionHelper.newArrayList();
                theValue.put(key, partition);
            }
            partition.add(v);
        }
        return theValue;
    }

    public static <K, V> Map<K, Set<V>> partition(Set<V> set, Partitioner<K, V> partitioner) {
        if (set == null) {
            return Collections.emptyMap();
        }
        HashMap theValue = CollectionHelper.newHashMap();
        for (V v : set) {
            K key = partitioner.getPartition(v);
            HashSet partition = (HashSet)theValue.get(key);
            if (partition == null) {
                partition = CollectionHelper.newHashSet();
                theValue.put(key, partition);
            }
            partition.add(v);
        }
        return theValue;
    }

    public static interface Partitioner<K, V> {
        public K getPartition(V var1);
    }
}

