/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterService
extends AbstractLifecycleComponent {
    private final MasterService masterService;
    private final ClusterApplierService clusterApplierService;
    public static final Setting.AffixSetting<String> USER_DEFINED_META_DATA = Setting.prefixKeySetting("cluster.metadata.", key -> Setting.simpleString(key, Setting.Property.Dynamic, Setting.Property.NodeScope));
    private final Settings settings;
    private final ClusterName clusterName;
    private final OperationRouting operationRouting;
    private final ClusterSettings clusterSettings;
    private final String nodeName;

    public ClusterService(Settings settings, ClusterSettings clusterSettings, ThreadPool threadPool) {
        this(settings, clusterSettings, new MasterService(settings, clusterSettings, threadPool), new ClusterApplierService(Node.NODE_NAME_SETTING.get(settings), settings, clusterSettings, threadPool));
    }

    public ClusterService(Settings settings, ClusterSettings clusterSettings, MasterService masterService, ClusterApplierService clusterApplierService) {
        this.settings = settings;
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.masterService = masterService;
        this.operationRouting = new OperationRouting(settings, clusterSettings);
        this.clusterSettings = clusterSettings;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.clusterSettings.addAffixUpdateConsumer(USER_DEFINED_META_DATA, (first, second) -> {}, (first, second) -> {});
        this.clusterApplierService = clusterApplierService;
    }

    public synchronized void setNodeConnectionsService(NodeConnectionsService nodeConnectionsService) {
        this.clusterApplierService.setNodeConnectionsService(nodeConnectionsService);
    }

    @Override
    protected synchronized void doStart() {
        this.clusterApplierService.start();
        this.masterService.start();
    }

    @Override
    protected synchronized void doStop() {
        this.masterService.stop();
        this.clusterApplierService.stop();
    }

    @Override
    protected synchronized void doClose() {
        this.masterService.close();
        this.clusterApplierService.close();
    }

    public DiscoveryNode localNode() {
        DiscoveryNode localNode = this.state().getNodes().getLocalNode();
        if (localNode == null) {
            throw new IllegalStateException("No local node found. Is the node started?");
        }
        return localNode;
    }

    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    public ClusterState state() {
        return this.clusterApplierService.state();
    }

    public void addHighPriorityApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addHighPriorityApplier(applier);
    }

    public void addLowPriorityApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addLowPriorityApplier(applier);
    }

    public void addStateApplier(ClusterStateApplier applier) {
        this.clusterApplierService.addStateApplier(applier);
    }

    public void removeApplier(ClusterStateApplier applier) {
        this.clusterApplierService.removeApplier(applier);
    }

    public void addListener(ClusterStateListener listener) {
        this.clusterApplierService.addListener(listener);
    }

    public void removeListener(ClusterStateListener listener) {
        this.clusterApplierService.removeListener(listener);
    }

    public void addLocalNodeMasterListener(LocalNodeMasterListener listener) {
        this.clusterApplierService.addLocalNodeMasterListener(listener);
    }

    public MasterService getMasterService() {
        return this.masterService;
    }

    public ClusterApplierService getClusterApplierService() {
        return this.clusterApplierService;
    }

    public static boolean assertClusterOrMasterStateThread() {
        assert (Thread.currentThread().getName().contains("clusterApplierService#updateTask") || Thread.currentThread().getName().contains("masterService#updateTask")) : "not called from the master/cluster state update thread";
        return true;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public <T extends ClusterStateTaskConfig & ClusterStateTaskExecutor<T>> void submitStateUpdateTask(String source, T updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, (ClusterStateTaskListener)updateTask);
    }

    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.submitStateUpdateTasks(source, Collections.singletonMap(task, listener), config, executor);
    }

    public <T> void submitStateUpdateTasks(String source, Map<T, ClusterStateTaskListener> tasks, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor) {
        this.masterService.submitStateUpdateTasks(source, tasks, config, executor);
    }
}

