/*
 * Decompiled with CFR 0.152.
 */
package org.jline.console.impl;

import java.util.regex.Pattern;
import org.jline.builtins.Nano;
import org.jline.console.SystemRegistry;
import org.jline.reader.LineReader;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;

public class SystemHighlighter
extends DefaultHighlighter {
    private final Nano.SyntaxHighlighter commandHighlighter;
    private final Nano.SyntaxHighlighter argsHighlighter;
    private final Nano.SyntaxHighlighter langHighlighter;
    private final SystemRegistry systemRegistry;
    private Pattern errorPattern;
    private int errorIndex = -1;

    public SystemHighlighter(Nano.SyntaxHighlighter commandHighlighter, Nano.SyntaxHighlighter argsHighlighter, Nano.SyntaxHighlighter langHighlighter) {
        this.commandHighlighter = commandHighlighter;
        this.argsHighlighter = argsHighlighter;
        this.langHighlighter = langHighlighter;
        this.systemRegistry = SystemRegistry.get();
    }

    @Override
    public void setErrorPattern(Pattern errorPattern) {
        this.errorPattern = errorPattern;
        super.setErrorPattern(errorPattern);
    }

    @Override
    public void setErrorIndex(int errorIndex) {
        this.errorIndex = errorIndex;
        super.setErrorIndex(errorIndex);
    }

    @Override
    public AttributedString highlight(LineReader reader, String buffer) {
        return this.doDefaultHighlight(reader) ? super.highlight(reader, buffer) : this.systemHighlight(reader.getParser(), buffer);
    }

    private boolean doDefaultHighlight(LineReader reader) {
        String search = reader.getSearchTerm();
        return search != null && search.length() > 0 || reader.getRegionActive() != LineReader.RegionType.NONE || this.errorIndex > -1 || this.errorPattern != null;
    }

    private AttributedString systemHighlight(Parser parser, String buffer) {
        AttributedString out;
        String command = parser.getCommand(buffer.trim().split("\\s+")[0]);
        if (buffer.trim().isEmpty()) {
            out = new AttributedStringBuilder().append(buffer).toAttributedString();
        } else if (this.systemRegistry.isCommandOrScript(command) || this.systemRegistry.isCommandAlias(command)) {
            if (this.commandHighlighter != null || this.argsHighlighter != null) {
                int idx = -1;
                boolean cmdFound = false;
                for (int i = 0; i < buffer.length(); ++i) {
                    char c = buffer.charAt(i);
                    if (c != ' ') {
                        cmdFound = true;
                        continue;
                    }
                    if (!cmdFound) continue;
                    idx = i;
                    break;
                }
                AttributedStringBuilder asb = new AttributedStringBuilder();
                if (idx < 0) {
                    this.highlightCommand(buffer, asb);
                } else {
                    this.highlightCommand(buffer.substring(0, idx), asb);
                    if (this.argsHighlighter != null) {
                        asb.append(this.argsHighlighter.highlight(buffer.substring(idx)));
                    } else {
                        asb.append(buffer.substring(idx));
                    }
                }
                out = asb.toAttributedString();
            } else {
                out = new AttributedStringBuilder().append(buffer).toAttributedString();
            }
        } else {
            out = this.langHighlighter != null ? this.langHighlighter.highlight(buffer) : new AttributedStringBuilder().append(buffer).toAttributedString();
        }
        return out;
    }

    private void highlightCommand(String command, AttributedStringBuilder asb) {
        if (this.commandHighlighter != null) {
            asb.append(this.commandHighlighter.highlight(command));
        } else {
            asb.append(command);
        }
    }
}

