/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ElementInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public abstract class MemberInfo
extends ElementInfo {
    public final String name;
    public final String descriptor;

    protected MemberInfo(int access, String name, String descriptor, Attribute[] attributes) {
        super(access, attributes);
        this.name = name;
        this.descriptor = descriptor;
    }

    String toString(int access_mask) {
        StringBuilder sb = new StringBuilder();
        sb.append(Modifier.toString(this.access & access_mask));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        return sb.append(this.name).append(' ').append(this.descriptor).append(' ').append(Arrays.toString(this.attributes)).toString();
    }

    static <M extends MemberInfo> M read(DataInput in, ConstantPool constant_pool, Constructor<M> constructor) throws IOException {
        int access_flags = in.readUnsignedShort();
        int name_index = in.readUnsignedShort();
        int descriptor_index = in.readUnsignedShort();
        Attribute[] attributes = Attribute.readAttributes(in, constant_pool);
        return constructor.init(access_flags, constant_pool.utf8(name_index), constant_pool.utf8(descriptor_index), attributes);
    }

    public void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int name_index = constant_pool.utf8Info(this.name);
        int descriptor_index = constant_pool.utf8Info(this.descriptor);
        out.writeShort(this.access);
        out.writeShort(name_index);
        out.writeShort(descriptor_index);
        Attribute.writeAttributes(out, constant_pool, this.attributes);
    }

    @FunctionalInterface
    public static interface Constructor<M extends MemberInfo> {
        public M init(int var1, String var2, String var3, Attribute[] var4);
    }
}

