/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.jmx;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import org.apache.cxf.common.logging.LogUtils;
import sun.rmi.registry.RegistryImpl;

public final class MBServerConnectorFactory {
    public static final String DEFAULT_SERVICE_URL = "service:jmx:rmi:///jndi/rmi://localhost:9913/jmxrmi";
    private static final Logger LOG = LogUtils.getL7dLogger(MBServerConnectorFactory.class);
    private static MBeanServer server;
    private static String serviceUrl;
    private static Map<String, ?> environment;
    private static boolean threaded;
    private static boolean daemon;
    private static JMXConnectorServer connectorServer;
    private static Remote remoteServerStub;
    private static RMIJRMPServerImpl rmiServer;

    private MBServerConnectorFactory() {
    }

    private static int indexNotOfNumber(String str, int index) {
        int i = 0;
        for (i = index; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            return i;
        }
        return -1;
    }

    public static MBServerConnectorFactory getInstance() {
        return MBServerConnectorFactoryHolder.INSTANCE;
    }

    public void setMBeanServer(MBeanServer ms) {
        server = ms;
    }

    public void setServiceUrl(String url) {
        serviceUrl = url;
    }

    public void setEnvironment(Map<String, ?> env) {
        environment = env;
    }

    public void setThreaded(boolean fthread) {
        threaded = fthread;
    }

    public void setDaemon(boolean fdaemon) {
        daemon = fdaemon;
    }

    public void createConnector() throws IOException {
        if (server == null) {
            server = MBeanServerHolder.INSTANCE;
        }
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        if (serviceUrl.indexOf("localhost") > -1 && url.getProtocol().compareToIgnoreCase("rmi") == 0) {
            try {
                int port = MBServerConnectorFactory.getRegistryPort(serviceUrl);
                new JmxRegistry(port, MBServerConnectorFactory.getBindingName(url));
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "CREATE_REGISTRY_FAULT_MSG", new Object[]{ex});
            }
        }
        rmiServer = new RMIJRMPServerImpl(url.getPort(), null, null, environment);
        connectorServer = new RMIConnectorServer(url, environment, rmiServer, server);
        if (threaded) {
            Thread connectorThread = new Thread(){

                @Override
                public void run() {
                    try {
                        connectorServer.start();
                        remoteServerStub = rmiServer.toStub();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "START_CONNECTOR_FAILURE_MSG", new Object[]{ex});
                    }
                }
            };
            connectorThread.setName("JMX Connector Thread [" + serviceUrl + "]");
            connectorThread.setDaemon(daemon);
            connectorThread.start();
        } else {
            connectorServer.start();
            remoteServerStub = rmiServer.toStub();
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("JMX connector server started: " + connectorServer);
        }
    }

    static int getRegistryPort(String url) {
        int portEnd;
        int serverStart = url.indexOf("/jndi/rmi://");
        String serverPart = url.substring(serverStart + 12);
        int portStart = serverPart.indexOf(58) + 1;
        int port = 0;
        if (portStart > 0 && (portEnd = MBServerConnectorFactory.indexNotOfNumber(serverPart, portStart)) > portStart) {
            String portString = serverPart.substring(portStart, portEnd);
            port = Integer.parseInt(portString);
        }
        return port;
    }

    protected static String getBindingName(JMXServiceURL jmxServiceURL) {
        String urlPath = jmxServiceURL.getURLPath();
        try {
            if (urlPath.startsWith("/jndi/")) {
                return new URI(urlPath.substring(6)).getPath().replaceAll("^/+", "").replaceAll("/+$", "");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return "jmxrmi";
    }

    public void destroy() throws IOException {
        connectorServer.stop();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("JMX connector server stopped: " + connectorServer);
        }
    }

    static {
        serviceUrl = DEFAULT_SERVICE_URL;
    }

    private class JmxRegistry
    extends RegistryImpl {
        private final String lookupName;

        JmxRegistry(int port, String lookupName) throws RemoteException {
            super(port);
            this.lookupName = lookupName;
        }

        @Override
        public Remote lookup(String s) throws RemoteException, NotBoundException {
            return this.lookupName.equals(s) ? remoteServerStub : null;
        }

        @Override
        public void bind(String s, Remote remote) throws RemoteException, AlreadyBoundException, AccessException {
        }

        @Override
        public void unbind(String s) throws RemoteException, NotBoundException, AccessException {
        }

        @Override
        public void rebind(String s, Remote remote) throws RemoteException, AccessException {
        }

        @Override
        public String[] list() throws RemoteException {
            return new String[]{this.lookupName};
        }
    }

    private static class MBeanServerHolder {
        private static final MBeanServer INSTANCE = MBeanServerFactory.createMBeanServer();

        private MBeanServerHolder() {
        }
    }

    private static class MBServerConnectorFactoryHolder {
        private static final MBServerConnectorFactory INSTANCE = new MBServerConnectorFactory();

        private MBServerConnectorFactoryHolder() {
        }
    }
}

