/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;

public final class FieldCapabilitiesRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    public static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    public static final String NAME = "field_caps_request";
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private String[] fields = Strings.EMPTY_ARRAY;
    private boolean includeUnmapped = false;
    private boolean mergeResults = true;
    private static ObjectParser<FieldCapabilitiesRequest, Void> PARSER = new ObjectParser("field_caps_request", FieldCapabilitiesRequest::new);

    public FieldCapabilitiesRequest(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readStringArray();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.mergeResults = in.readBoolean();
        this.includeUnmapped = in.getVersion().onOrAfter(Version.V_7_2_0) ? in.readBoolean() : false;
    }

    public FieldCapabilitiesRequest() {
    }

    boolean isMergeResults() {
        return this.mergeResults;
    }

    void setMergeResults(boolean mergeResults) {
        this.mergeResults = mergeResults;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.fields);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBoolean(this.mergeResults);
        if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
            out.writeBoolean(this.includeUnmapped);
        }
    }

    public FieldCapabilitiesRequest fields(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("specified fields can't be null or empty");
        }
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fields));
        this.fields = fieldSet.toArray(new String[0]);
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    @Override
    public FieldCapabilitiesRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices, "indices must not be null");
        return this;
    }

    public FieldCapabilitiesRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indices options must not be null");
        return this;
    }

    public FieldCapabilitiesRequest includeUnmapped(boolean includeUnmapped) {
        this.includeUnmapped = includeUnmapped;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public boolean includeUnmapped() {
        return this.includeUnmapped;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.fields == null || this.fields.length == 0) {
            validationException = ValidateActions.addValidationError("no fields specified", validationException);
        }
        return validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesRequest that = (FieldCapabilitiesRequest)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Arrays.equals(this.fields, that.fields) && Objects.equals(this.mergeResults, that.mergeResults) && this.includeUnmapped == that.includeUnmapped;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.indicesOptions, Arrays.hashCode(this.fields), this.mergeResults, this.includeUnmapped);
    }

    static {
        PARSER.declareStringArray(ObjectParser.fromList(String.class, FieldCapabilitiesRequest::fields), FIELDS_FIELD);
    }
}

