/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.kar;

import java.net.URI;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.kar.ClusterKarEvent;
import org.apache.karaf.kar.KarService;
import org.apache.karaf.shell.api.action.lifecycle.Reference;

public class KarEventHandler
extends CellarSupport
implements EventHandler<ClusterKarEvent> {
    public static final String SWITCH_ID = "org.apache.karaf.cellar.event.kar.handler";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.event.kar.handler");
    @Reference
    private KarService karService;

    public void handle(ClusterKarEvent event) {
        if (event.isInstall()) {
            try {
                String karUrl = event.getId();
                this.karService.install(new URI(karUrl));
            }
            catch (Exception e) {
                LOGGER.error("CELLAR KAR: can't install {}", (Object)event.getId(), (Object)e);
                return;
            }
        }
        try {
            this.karService.uninstall(event.getId());
        }
        catch (Exception e) {
            LOGGER.error("CELLAR KAR: can't uninstall {}", (Object)event.getId(), (Object)e);
            return;
        }
    }

    public Class<ClusterKarEvent> getType() {
        return ClusterKarEvent.class;
    }

    public Switch getSwitch() {
        return this.eventSwitch;
    }

    public KarService getKarService() {
        return this.karService;
    }

    public void setKarService(KarService karService) {
        this.karService = karService;
    }
}

