/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell.group;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.control.ManageGroupAction;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.cellar.core.shell.completer.LocalGroupsCompleter;
import org.apache.karaf.cellar.shell.group.GroupSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="cluster", name="group-pick", description="Picks a number of nodes from one cluster group and moves them into another")
@Service
public class GroupPickCommand
extends GroupSupport {
    @Argument(index=0, name="sourceGroupName", description="The source cluster group name", required=true, multiValued=false)
    @Completion(value=LocalGroupsCompleter.class)
    String sourceGroupName;
    @Argument(index=1, name="targetGroupName", description="The destination cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String targetGroupName;
    @Argument(index=2, name="count", description="The number of nodes to transfer", required=false, multiValued=false)
    int count = 1;

    protected Object doExecute() throws Exception {
        Group sourceGroup = this.groupManager.findGroupByName(this.sourceGroupName);
        if (sourceGroup == null) {
            System.err.println("Source cluster group " + this.sourceGroupName + " doesn't exist");
            return null;
        }
        Group targetGroup = this.groupManager.findGroupByName(this.targetGroupName);
        if (targetGroup == null) {
            System.err.println("Target cluster group " + this.targetGroupName + " doesn't exist");
            return null;
        }
        Set groupMembers = sourceGroup.getNodes();
        if (this.count > groupMembers.size()) {
            this.count = groupMembers.size();
        }
        int i = 0;
        for (Node node : groupMembers) {
            if (i >= this.count) break;
            LinkedList<String> recipients = new LinkedList<String>();
            recipients.add(node.getId());
            this.doExecute(ManageGroupAction.SET, this.targetGroupName, sourceGroup, recipients);
            ++i;
        }
        return this.doExecute(ManageGroupAction.LIST, null, null, new ArrayList<String>(), false);
    }
}

