/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.cellar.bundle.BundleState;
import org.apache.karaf.cellar.bundle.shell.completers.AllBundlesNameCompleter;
import org.apache.karaf.cellar.core.shell.CellarCommandSupport;
import org.apache.karaf.cellar.core.shell.completer.AllGroupsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class BundleCommandSupport
extends CellarCommandSupport {
    @Argument(index=0, name="group", description="The cluster group name", required=true, multiValued=false)
    @Completion(value=AllGroupsCompleter.class)
    String groupName;
    @Argument(index=1, name="ids", description="The list of bundle (identified by IDs or name or name/version) separated by whitespaces", required=false, multiValued=true)
    @Completion(value=AllBundlesNameCompleter.class)
    List<String> ids;
    @Reference
    protected BundleContext bundleContext;

    protected abstract Object doExecute() throws Exception;

    protected List<String> selector(Map<String, ExtendedBundleState> clusterBundles) {
        ArrayList<String> bundles = new ArrayList<String>();
        if (this.ids != null && !this.ids.isEmpty()) {
            for (String id : this.ids) {
                if (id == null) continue;
                this.addMatchingBundles(id, bundles, clusterBundles);
            }
        }
        return bundles;
    }

    protected void addMatchingBundles(String nameId, List<String> bundles, Map<String, ExtendedBundleState> clusterBundles) {
        Pattern pattern = Pattern.compile("^\\d+$");
        Matcher matcher = pattern.matcher(nameId);
        if (matcher.matches()) {
            int id = Integer.parseInt(nameId);
            for (String bundle : clusterBundles.keySet()) {
                if (clusterBundles.get(bundle).getId() != (long)id) continue;
                bundles.add(bundle);
                break;
            }
            return;
        }
        pattern = Pattern.compile("^(\\d+)-(\\d+)$");
        matcher = pattern.matcher(nameId);
        if (matcher.matches()) {
            long endId;
            int index = nameId.indexOf(45);
            long startId = Long.parseLong(nameId.substring(0, index));
            if (startId < (endId = Long.parseLong(nameId.substring(index + 1)))) {
                int bundleIndex = 0;
                for (String bundle : clusterBundles.keySet()) {
                    if ((long)bundleIndex >= startId && (long)bundleIndex <= endId) {
                        bundles.add(bundle);
                    }
                    ++bundleIndex;
                }
            }
            return;
        }
        int index = nameId.indexOf(47);
        if (index != -1) {
            String[] idSplit = nameId.split("/");
            String name = idSplit[0];
            String version = idSplit[1];
            for (String bundle : clusterBundles.keySet()) {
                String[] bundleSplit = bundle.split("/");
                if (!bundleSplit[1].equals(version)) continue;
                Pattern namePattern = Pattern.compile(name);
                BundleState state = clusterBundles.get(bundle);
                if (state.getName() != null) {
                    matcher = namePattern.matcher(state.getName());
                    if (matcher.matches()) {
                        bundles.add(bundle);
                        continue;
                    }
                    matcher = namePattern.matcher(bundleSplit[0]);
                    if (!matcher.matches()) continue;
                    bundles.add(bundle);
                    continue;
                }
                if (state.getSymbolicName() != null) {
                    matcher = namePattern.matcher(state.getSymbolicName());
                    if (matcher.matches()) {
                        bundles.add(bundle);
                        continue;
                    }
                    matcher = namePattern.matcher(bundleSplit[0]);
                    if (!matcher.matches()) continue;
                    bundles.add(bundle);
                    continue;
                }
                matcher = namePattern.matcher(bundleSplit[0]);
                if (!matcher.matches()) continue;
                bundles.add(bundle);
            }
            return;
        }
        Pattern namePattern = Pattern.compile(nameId);
        for (String bundle : clusterBundles.keySet()) {
            String[] idSplit;
            BundleState state = clusterBundles.get(bundle);
            if (state.getName() != null) {
                matcher = namePattern.matcher(state.getName());
                if (matcher.matches()) {
                    bundles.add(bundle);
                    continue;
                }
                idSplit = bundle.split("/");
                matcher = namePattern.matcher(idSplit[0]);
                if (!matcher.matches()) continue;
                bundles.add(bundle);
                continue;
            }
            if (state.getSymbolicName() != null) {
                matcher = namePattern.matcher(state.getSymbolicName());
                if (matcher.matches()) {
                    bundles.add(bundle);
                    continue;
                }
                idSplit = bundle.split("/");
                matcher = namePattern.matcher(idSplit[0]);
                if (!matcher.matches()) continue;
                bundles.add(bundle);
                continue;
            }
            idSplit = bundle.split("/");
            matcher = namePattern.matcher(idSplit[0]);
            if (!matcher.matches()) continue;
            bundles.add(bundle);
        }
    }

    protected Map<String, ExtendedBundleState> gatherBundles(boolean clusterOnly) {
        HashMap<String, ExtendedBundleState> bundles = new HashMap<String, ExtendedBundleState>();
        Map clusterBundles = this.clusterManager.getMap("org.apache.karaf.cellar.bundle.map." + this.groupName);
        for (String key : clusterBundles.keySet()) {
            BundleState state = (BundleState)clusterBundles.get(key);
            ExtendedBundleState extendedState = new ExtendedBundleState();
            extendedState.setId(state.getId());
            extendedState.setName(state.getName());
            extendedState.setSymbolicName(state.getSymbolicName());
            extendedState.setStatus(state.getStatus());
            extendedState.setLocation(state.getLocation());
            extendedState.setVersion(state.getVersion());
            extendedState.setCluster(true);
            extendedState.setLocal(false);
            bundles.put(key, extendedState);
        }
        if (clusterOnly) {
            return bundles;
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            ExtendedBundleState extendedState;
            String version = (String)bundle.getHeaders().get("Bundle-Version");
            String symbolicName = bundle.getSymbolicName();
            String key = symbolicName + "/" + version;
            if (bundles.containsKey(key)) {
                extendedState = (ExtendedBundleState)bundles.get(key);
                extendedState.setLocal(true);
                continue;
            }
            extendedState = new ExtendedBundleState();
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            name = name == null ? symbolicName : name;
            name = name == null ? bundle.getLocation() : name;
            extendedState.setId(bundle.getBundleId());
            extendedState.setName(name);
            extendedState.setSymbolicName(symbolicName);
            extendedState.setVersion((String)bundle.getHeaders().get("Bundle-Version"));
            extendedState.setLocation(bundle.getLocation());
            extendedState.setStatus(bundle.getState());
            extendedState.setCluster(false);
            extendedState.setLocal(true);
            bundles.put(key, extendedState);
        }
        return bundles;
    }

    class ExtendedBundleState
    extends BundleState {
        private boolean cluster;
        private boolean local;

        ExtendedBundleState() {
        }

        public boolean isCluster() {
            return this.cluster;
        }

        public void setCluster(boolean cluster) {
            this.cluster = cluster;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }
    }
}

