/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.core.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.unomi.router.api.ImportConfiguration;
import org.apache.unomi.router.api.services.ImportExportConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportConfigByFileNameProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger((String)ImportConfigByFileNameProcessor.class.getName());
    private ImportExportConfigurationService<ImportConfiguration> importConfigurationService;

    public void process(Exchange exchange) throws Exception {
        String fileName = ((GenericFile)exchange.getIn().getBody(GenericFile.class)).getFileName();
        String importConfigId = fileName.substring(0, fileName.indexOf(46));
        ImportConfiguration importConfiguration = (ImportConfiguration)this.importConfigurationService.load(importConfigId);
        if (importConfiguration != null) {
            logger.debug("Set a header with import configuration found for ID : {}", (Object)importConfigId);
            exchange.getIn().setHeader("importConfigOneShot", (Object)importConfiguration);
        } else {
            logger.warn("No import configuration found with ID : {}", (Object)importConfigId);
            exchange.setProperty("CamelRouteStop", (Object)Boolean.TRUE);
        }
    }

    public void setImportConfigurationService(ImportExportConfigurationService<ImportConfiguration> importConfigurationService) {
        this.importConfigurationService = importConfigurationService;
    }
}

