/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.service.impl;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.PersonaWithSessions;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.rest.exception.InvalidRequestException;
import org.apache.unomi.rest.service.RestServiceUtils;
import org.apache.unomi.schema.api.SchemaService;
import org.apache.unomi.utils.EventsRequestContext;
import org.apache.unomi.utils.HttpUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={RestServiceUtils.class})
public class RestServiceUtilsImpl
implements RestServiceUtils {
    private static final String DEFAULT_CLIENT_ID = "defaultClientId";
    private static final Logger logger = LoggerFactory.getLogger((String)RestServiceUtilsImpl.class.getName());
    @Reference
    private ConfigSharingService configSharingService;
    @Reference
    private PrivacyService privacyService;
    @Reference
    private EventService eventService;
    @Reference
    private ProfileService profileService;
    @Reference
    SchemaService schemaService;

    @Override
    public String getProfileIdCookieValue(HttpServletRequest httpServletRequest) {
        String cookieProfileId = null;
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies != null) {
            Object profileIdCookieName = this.configSharingService.getProperty("profileIdCookieName");
            for (Cookie cookie : cookies) {
                if (!profileIdCookieName.equals(cookie.getName())) continue;
                String profileIdJSON = JsonNodeFactory.instance.objectNode().put("profileId", cookie.getValue()).toString();
                if (!this.schemaService.isValid(profileIdJSON, "https://unomi.apache.org/schemas/json/rest/requestIds/1-0-0")) {
                    throw new InvalidRequestException("Invalid profile ID format in cookie", "Invalid received data");
                }
                cookieProfileId = cookie.getValue();
            }
        }
        return cookieProfileId;
    }

    @Override
    public EventsRequestContext initEventsRequest(String scope, String sessionId, String profileId, String personaId, boolean invalidateProfile, boolean invalidateSession, HttpServletRequest request, HttpServletResponse response, Date timestamp) {
        EventsRequestContext eventsRequestContext = new EventsRequestContext(timestamp, null, null, request, response);
        if (personaId != null) {
            PersonaWithSessions personaWithSessions = this.profileService.loadPersonaWithSessions(personaId);
            if (personaWithSessions == null) {
                logger.error("Couldn't find persona, please check your personaId parameter");
            } else {
                eventsRequestContext.setProfile((Profile)personaWithSessions.getPersona());
                eventsRequestContext.setSession((Session)personaWithSessions.getLastSession());
            }
        }
        if (profileId == null) {
            profileId = this.getProfileIdCookieValue(request);
        }
        if (profileId == null && sessionId == null && personaId == null) {
            logger.error("Couldn't find profileId, sessionId or personaId in incoming request! Stopped processing request. See debug level for more information");
            if (logger.isDebugEnabled()) {
                logger.debug("Request dump: {}", (Object)HttpUtils.dumpRequestInfo(request));
            }
            throw new BadRequestException("Couldn't find profileId, sessionId or personaId in incoming request!");
        }
        boolean profileCreated = false;
        if (eventsRequestContext.getProfile() == null) {
            Profile sessionProfile;
            if (profileId == null || invalidateProfile) {
                eventsRequestContext.setProfile(this.createNewProfile(null, timestamp));
                profileCreated = true;
            } else {
                eventsRequestContext.setProfile(this.profileService.load(profileId));
                if (eventsRequestContext.getProfile() == null) {
                    eventsRequestContext.setProfile(this.createNewProfile(profileId, timestamp));
                    profileCreated = true;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)sessionId) && !invalidateSession) {
                eventsRequestContext.setSession(this.profileService.loadSession(sessionId));
                if (eventsRequestContext.getSession() != null) {
                    Boolean requireAnonymousBrowsing;
                    sessionProfile = eventsRequestContext.getSession().getProfile();
                    boolean anonymousSessionProfile = sessionProfile.isAnonymousProfile();
                    if (!(eventsRequestContext.getProfile().isAnonymousProfile() || anonymousSessionProfile || eventsRequestContext.getProfile().getItemId().equals(sessionProfile.getItemId()))) {
                        eventsRequestContext.setProfile(this.profileService.load(sessionProfile.getItemId()));
                    }
                    if (!(requireAnonymousBrowsing = this.privacyService.isRequireAnonymousBrowsing(eventsRequestContext.getProfile())).booleanValue() || !anonymousSessionProfile) {
                        if (requireAnonymousBrowsing.booleanValue() && !anonymousSessionProfile) {
                            sessionProfile = this.privacyService.getAnonymousProfile(eventsRequestContext.getProfile());
                            eventsRequestContext.getSession().setProfile(sessionProfile);
                            eventsRequestContext.addChanges(2);
                        } else if (!requireAnonymousBrowsing.booleanValue() && anonymousSessionProfile) {
                            sessionProfile = eventsRequestContext.getProfile();
                            eventsRequestContext.getSession().setProfile(sessionProfile);
                            eventsRequestContext.addChanges(2);
                        } else if (!requireAnonymousBrowsing.booleanValue() && !anonymousSessionProfile) {
                            sessionProfile = eventsRequestContext.getProfile();
                            if (!eventsRequestContext.getSession().getProfileId().equals(sessionProfile.getItemId())) {
                                eventsRequestContext.addChanges(2);
                            }
                            eventsRequestContext.getSession().setProfile(sessionProfile);
                        }
                    }
                }
            }
            if (eventsRequestContext.getSession() == null || invalidateSession) {
                Profile profile = sessionProfile = this.privacyService.isRequireAnonymousBrowsing(eventsRequestContext.getProfile()) != false ? this.privacyService.getAnonymousProfile(eventsRequestContext.getProfile()) : eventsRequestContext.getProfile();
                if (StringUtils.isNotBlank((CharSequence)sessionId)) {
                    Session session = new Session(sessionId, sessionProfile, timestamp, scope);
                    eventsRequestContext.setSession(session);
                    eventsRequestContext.setNewSession(true);
                    eventsRequestContext.addChanges(2);
                    Event event = new Event("sessionCreated", eventsRequestContext.getSession(), eventsRequestContext.getProfile(), scope, null, (Item)eventsRequestContext.getSession(), null, timestamp, false);
                    if (sessionProfile.isAnonymousProfile()) {
                        event.setProfileId(null);
                    }
                    event.getAttributes().put("http_request", request);
                    event.getAttributes().put("http_response", response);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received event {} for profile={} session={} target={} timestamp={}", new Object[]{event.getEventType(), eventsRequestContext.getProfile().getItemId(), eventsRequestContext.getSession().getItemId(), event.getTarget(), timestamp});
                    }
                    eventsRequestContext.addChanges(this.eventService.send(event));
                }
            }
            if (profileCreated) {
                eventsRequestContext.addChanges(4);
                Event profileUpdated = new Event("profileUpdated", eventsRequestContext.getSession(), eventsRequestContext.getProfile(), scope, null, (Item)eventsRequestContext.getProfile(), timestamp);
                profileUpdated.setPersistent(false);
                profileUpdated.getAttributes().put("http_request", request);
                profileUpdated.getAttributes().put("http_response", response);
                profileUpdated.getAttributes().put("client_id", DEFAULT_CLIENT_ID);
                if (logger.isDebugEnabled()) {
                    logger.debug("Received event {} for profile={} {} target={} timestamp={}", new Object[]{profileUpdated.getEventType(), eventsRequestContext.getProfile().getItemId(), " session=" + (eventsRequestContext.getSession() != null ? eventsRequestContext.getSession().getItemId() : null), profileUpdated.getTarget(), timestamp});
                }
                eventsRequestContext.addChanges(this.eventService.send(profileUpdated));
            }
        }
        return eventsRequestContext;
    }

    @Override
    public EventsRequestContext performEventsRequest(List<Event> events, EventsRequestContext eventsRequestContext) {
        List filteredEventTypes = this.privacyService.getFilteredEventTypes(eventsRequestContext.getProfile());
        String thirdPartyId = this.eventService.authenticateThirdPartyServer(eventsRequestContext.getRequest().getHeader("X-Unomi-Peer"), eventsRequestContext.getRequest().getRemoteAddr());
        if (events != null && !(eventsRequestContext.getProfile() instanceof Persona)) {
            eventsRequestContext.setTotalItems(events.size());
            for (Event event : events) {
                eventsRequestContext.setProcessedItems(eventsRequestContext.getProcessedItems() + 1);
                if (event.getEventType() == null) continue;
                Event eventToSend = new Event(event.getEventType(), eventsRequestContext.getSession(), eventsRequestContext.getProfile(), event.getScope(), event.getSource(), event.getTarget(), event.getProperties(), eventsRequestContext.getTimestamp(), event.isPersistent());
                eventToSend.setFlattenedProperties(event.getFlattenedProperties());
                if (!this.eventService.isEventAllowed(event, thirdPartyId)) {
                    logger.warn("Event is not allowed : {}", (Object)event.getEventType());
                    continue;
                }
                if (thirdPartyId != null && event.getItemId() != null) {
                    eventToSend = new Event(event.getItemId(), event.getEventType(), eventsRequestContext.getSession(), eventsRequestContext.getProfile(), event.getScope(), event.getSource(), event.getTarget(), event.getProperties(), eventsRequestContext.getTimestamp(), event.isPersistent());
                    eventToSend.setFlattenedProperties(event.getFlattenedProperties());
                }
                if (filteredEventTypes != null && filteredEventTypes.contains(event.getEventType())) {
                    logger.debug("Profile is filtering event type {}", (Object)event.getEventType());
                    continue;
                }
                if (eventsRequestContext.getProfile().isAnonymousProfile()) {
                    eventToSend.setProfileId(null);
                }
                eventToSend.getAttributes().put("http_request", eventsRequestContext.getRequest());
                eventToSend.getAttributes().put("http_response", eventsRequestContext.getResponse());
                logger.debug("Received event " + event.getEventType() + " for profile=" + eventsRequestContext.getProfile().getItemId() + " session=" + (eventsRequestContext.getSession() != null ? eventsRequestContext.getSession().getItemId() : null) + " target=" + event.getTarget() + " timestamp=" + eventsRequestContext.getTimestamp());
                eventsRequestContext.addChanges(this.eventService.send(eventToSend));
                if ((eventsRequestContext.getChanges() & 4) == 4) {
                    eventsRequestContext.setProfile(eventToSend.getProfile());
                }
                if (eventsRequestContext.isNewSession()) {
                    eventsRequestContext.getSession().getOriginEventIds().add(eventToSend.getItemId());
                    eventsRequestContext.getSession().getOriginEventTypes().add(eventToSend.getEventType());
                }
                if ((eventsRequestContext.getChanges() & 1) != 1) continue;
                eventsRequestContext.setProcessedItems(eventsRequestContext.getProcessedItems() - 1);
                logger.error("Error processing events. Total number of processed events: {}/{}", (Object)eventsRequestContext.getProcessedItems(), (Object)eventsRequestContext.getTotalItems());
                break;
            }
        }
        return eventsRequestContext;
    }

    @Override
    public void finalizeEventsRequest(EventsRequestContext eventsRequestContext, boolean crashOnError) {
        if ((eventsRequestContext.getChanges() & 4) == 4) {
            this.profileService.save(eventsRequestContext.getProfile());
        }
        if ((eventsRequestContext.getChanges() & 2) == 2 && eventsRequestContext.getSession() != null) {
            this.profileService.saveSession(eventsRequestContext.getSession());
        }
        if ((eventsRequestContext.getChanges() & 1) == 1) {
            if (crashOnError) {
                String errorMessage = "Error processing events. Total number of processed events: " + eventsRequestContext.getProcessedItems() + "/" + eventsRequestContext.getTotalItems();
                throw new BadRequestException(errorMessage);
            }
            eventsRequestContext.getResponse().setStatus(500);
        }
        if (!(eventsRequestContext.getProfile() instanceof Persona)) {
            eventsRequestContext.getResponse().setHeader("Set-Cookie", HttpUtils.getProfileCookieString(eventsRequestContext.getProfile(), this.configSharingService, eventsRequestContext.getRequest().isSecure()));
        }
    }

    private Profile createNewProfile(String existingProfileId, Date timestamp) {
        String profileId = existingProfileId;
        if (profileId == null) {
            profileId = UUID.randomUUID().toString();
        }
        Profile profile = new Profile(profileId);
        profile.setProperty("firstVisit", (Object)timestamp);
        return profile;
    }
}

