/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.validation.request;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.rest.exception.InvalidRequestException;

public class RequestValidatorInterceptor
extends AbstractPhaseInterceptor<Message> {
    private final ConfigSharingService configSharingService;
    private static final List<String> PROTECTED_URIS = new ArrayList<String>(){
        {
            this.add("/cxs/eventcollector");
            this.add("/cxs/context.js");
            this.add("/cxs/context.json");
        }
    };

    public RequestValidatorInterceptor(ConfigSharingService configSharingService) {
        super("receive");
        this.configSharingService = configSharingService;
    }

    public void handleMessage(Message message) throws Fault {
        HttpServletRequest request;
        int bytesLimit = (Integer)this.configSharingService.getProperty("publicPostRequestBytesLimit");
        if (bytesLimit > 0 && (request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST")) != null && request.getMethod().equalsIgnoreCase("POST") && PROTECTED_URIS.contains(request.getRequestURI())) {
            try {
                int contentLength = Integer.parseInt(request.getHeader("Content-Length"));
                if (contentLength > bytesLimit) {
                    throw new InvalidRequestException(String.format("Incoming POST request blocked because exceeding maximum bytes size allowed on: %s (limit: %s, request size: %s)", request.getRequestURI(), bytesLimit, contentLength), "Request size exceed the limit");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

