/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indexlifecycle;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.TimedRequest;

public class RemoveIndexLifecyclePolicyRequest
extends TimedRequest {
    private final List<String> indices;
    private final IndicesOptions indicesOptions;

    public RemoveIndexLifecyclePolicyRequest(List<String> indices) {
        this(indices, IndicesOptions.strictExpandOpen());
    }

    public RemoveIndexLifecyclePolicyRequest(List<String> indices, IndicesOptions indicesOptions) {
        this.indices = Collections.unmodifiableList(Objects.requireNonNull(indices));
        this.indicesOptions = Objects.requireNonNull(indicesOptions);
    }

    public List<String> indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public int hashCode() {
        return Objects.hash(this.indices, this.indicesOptions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveIndexLifecyclePolicyRequest other = (RemoveIndexLifecyclePolicyRequest)obj;
        return Objects.deepEquals(this.indices, other.indices) && Objects.equals(this.indicesOptions, other.indicesOptions);
    }
}

