/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.authentication;

import jakarta.annotation.Priority;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.jaxrs.security.JAASAuthenticationFilter;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.unomi.rest.authentication.RestAuthenticationConfig;

@PreMatching
@Priority(value=1000)
public class AuthenticationFilter
implements ContainerRequestFilter {
    public static final String GUEST_USERNAME = "guest";
    public static final String GUEST_DEFAULT_ROLE = "ROLE_UNOMI_PUBLIC";
    private static final List<String> GUEST_ROLES = Collections.singletonList("ROLE_UNOMI_PUBLIC");
    private static final Subject GUEST_SUBJECT = new Subject();
    private static final String ROLE_CLASSIFIER = "ROLE_UNOMI";
    private static final String ROLE_CLASSIFIER_TYPE = "prefix";
    private static final String REALM_NAME = "cxs";
    private static final String CONTEXT_NAME = "karaf";
    private final JAASAuthenticationFilter jaasAuthenticationFilter;
    private final RestAuthenticationConfig restAuthenticationConfig;

    public AuthenticationFilter(RestAuthenticationConfig restAuthenticationConfig) {
        this.restAuthenticationConfig = restAuthenticationConfig;
        this.jaasAuthenticationFilter = new JAASAuthenticationFilter();
        this.jaasAuthenticationFilter.setRoleClassifier(ROLE_CLASSIFIER);
        this.jaasAuthenticationFilter.setRoleClassifierType(ROLE_CLASSIFIER_TYPE);
        this.jaasAuthenticationFilter.setContextName(CONTEXT_NAME);
        this.jaasAuthenticationFilter.setRealmName(REALM_NAME);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.isPublicPath(requestContext)) {
            JAXRSUtils.getCurrentMessage().put(SecurityContext.class, (Object)new RolePrefixSecurityContextImpl(GUEST_SUBJECT, ROLE_CLASSIFIER, ROLE_CLASSIFIER_TYPE));
        } else {
            this.jaasAuthenticationFilter.filter(requestContext);
        }
    }

    private boolean isPublicPath(ContainerRequestContext requestContext) {
        if (requestContext.getMethod() == null || requestContext.getMethod().length() > 10 || requestContext.getUriInfo().getPath() == null) {
            return false;
        }
        String currentPath = requestContext.getMethod() + " " + requestContext.getUriInfo().getPath();
        return this.restAuthenticationConfig.getPublicPathPatterns().stream().anyMatch(pattern -> pattern.matcher(currentPath).matches());
    }

    static {
        GUEST_SUBJECT.getPrincipals().add((Principal)new UserPrincipal(GUEST_USERNAME));
        for (String roleName : GUEST_ROLES) {
            GUEST_SUBJECT.getPrincipals().add((Principal)new RolePrincipal(roleName));
        }
    }
}

