/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.querybuilders.core;

import co.elastic.clients.elasticsearch._types.query_dsl.ChildScoreMode;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilderDispatcher;

public class NestedConditionESQueryBuilder
implements ConditionESQueryBuilder {
    @Override
    public Query buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        String path = (String)condition.getParameter("path");
        Condition subCondition = (Condition)condition.getParameter("subCondition");
        if (subCondition == null || path == null) {
            throw new IllegalArgumentException("Impossible to build Nested query, subCondition and path properties should be provided");
        }
        Query nestedQuery = dispatcher.buildFilter(subCondition, context);
        if (nestedQuery != null) {
            return Query.of(q -> q.nested(n -> n.path(path).query(nestedQuery).scoreMode(ChildScoreMode.Avg)));
        }
        throw new IllegalArgumentException("Impossible to build Nested query due to subCondition filter null");
    }
}

