/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.ext.awt.color.NamedProfileCache;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGColorProfileElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public NamedProfileCache cache = new NamedProfileCache();

    public String getLocalName() {
        return "color-profile";
    }

    public ICCColorSpaceExt createICCColorSpaceExt(BridgeContext bridgeContext, Element element, String string) {
        Object object;
        Object object2;
        Object object3;
        ICCColorSpaceExt iCCColorSpaceExt = this.cache.request(string.toLowerCase());
        if (iCCColorSpaceExt != null) {
            return iCCColorSpaceExt;
        }
        Document document = element.getOwnerDocument();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "color-profile");
        int n = nodeList.getLength();
        Object object4 = null;
        for (int i = 0; i < n; ++i) {
            object3 = nodeList.item(i);
            if (object3.getNodeType() != 1 || !string.equalsIgnoreCase((String)(object2 = (object = (Element)object3).getAttributeNS(null, "name")))) continue;
            object4 = object;
        }
        if (object4 == null) {
            return null;
        }
        String string2 = XLinkSupport.getXLinkHref(object4);
        object3 = null;
        if (string2 != null) {
            object = ((SVGOMDocument)document).getURL();
            object2 = new ParsedURL((String)object, string2);
            if (!((ParsedURL)object2).complete()) {
                throw new BridgeException(element, "uri.malformed", new Object[]{string2});
            }
            try {
                ParsedURL parsedURL = null;
                if (object != null) {
                    parsedURL = new ParsedURL((String)object);
                }
                bridgeContext.getUserAgent().checkLoadExternalResource((ParsedURL)object2, parsedURL);
                object3 = ICC_Profile.getInstance(((ParsedURL)object2).openStream());
            }
            catch (IOException iOException) {
                throw new BridgeException(element, "uri.io", new Object[]{string2});
            }
            catch (SecurityException securityException) {
                throw new BridgeException(element, "uri.unsecure", new Object[]{string2});
            }
        }
        if (object3 == null) {
            return null;
        }
        int n2 = SVGColorProfileElementBridge.convertIntent(object4);
        iCCColorSpaceExt = new ICCColorSpaceExt((ICC_Profile)object3, n2);
        this.cache.put(string.toLowerCase(), iCCColorSpaceExt);
        return iCCColorSpaceExt;
    }

    private static int convertIntent(Element element) {
        String string = element.getAttributeNS(null, "rendering-intent");
        if (string.length() == 0) {
            return 4;
        }
        if ("perceptual".equals(string)) {
            return 0;
        }
        if ("auto".equals(string)) {
            return 4;
        }
        if ("relative-colorimetric".equals(string)) {
            return 1;
        }
        if ("absolute-colorimetric".equals(string)) {
            return 2;
        }
        if ("saturation".equals(string)) {
            return 3;
        }
        throw new BridgeException(element, "attribute.malformed", new Object[]{"rendering-intent", string});
    }
}

