/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IOnChangeListener;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckGroup<T>
extends FormComponent<Collection<T>>
implements IOnChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CheckGroup.class);

    public CheckGroup(String id) {
        super(id);
        this.setRenderBodyOnly(true);
    }

    public CheckGroup(String id, Collection<T> collection) {
        this(id, new CollectionModel<T>(collection));
    }

    public CheckGroup(String id, IModel<? extends Collection<T>> model) {
        super(id, model);
        this.setRenderBodyOnly(true);
    }

    @Override
    protected String getModelValue() {
        final StringBuilder builder = new StringBuilder();
        final Collection ts = (Collection)this.getModelObject();
        this.visitChildren(Check.class, new IVisitor<Check<T>, Void>(){

            public void component(Check<T> check, IVisit<Void> visit) {
                if (ts.contains(check.getModelObject())) {
                    if (builder.length() > 0) {
                        builder.append(";");
                    }
                    builder.append(check.getValue());
                }
            }
        });
        return builder.toString();
    }

    @Override
    protected Collection<T> convertValue(String[] values) throws ConversionException {
        ArrayList collection = Generics.newArrayList();
        if (values != null && values.length > 0) {
            for (final String value : values) {
                if (value == null) continue;
                Check checkbox = (Check)this.visitChildren(Check.class, new IVisitor<Check<T>, Check<T>>(){

                    public void component(Check<T> check, IVisit<Check<T>> visit) {
                        if (String.valueOf(check.getValue()).equals(value)) {
                            visit.stop(check);
                        }
                    }
                });
                if (checkbox == null) {
                    throw new WicketRuntimeException("submitted http post value [" + Strings.join((String)",", (String[])values) + "] for CheckGroup component [" + this.getPath() + "] contains an illegal value [" + value + "] which does not point to a Check component. Due to this the CheckGroup component cannot resolve the selected Check component pointed to by the illegal value. A possible reason is that component hierarchy changed between rendering and form submission.");
                }
                collection.add(checkbox.getModelObject());
            }
        }
        return collection;
    }

    @Override
    public void updateModel() {
        FormComponent.updateCollectionModel(this);
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.remove("disabled");
        tag.remove("name");
    }

    @Override
    public final void onSelectionChanged() {
        this.convertInput();
        this.updateModel();
        this.onSelectionChanged((Collection)this.getModelObject());
    }

    protected void onSelectionChanged(Collection<T> newSelection) {
    }

    protected boolean wantOnSelectionChangedNotifications() {
        return false;
    }

    @Override
    protected boolean getStatelessHint() {
        if (this.wantOnSelectionChangedNotifications()) {
            return false;
        }
        return super.getStatelessHint();
    }
}

