/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.bundles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.resource.IScopeAwareTextResourceProcessor;
import org.apache.wicket.resource.ITextResourceCompressor;
import org.apache.wicket.util.io.ByteArrayOutputStream;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.AbstractTimeValue;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatBundleResource
extends AbstractResource
implements IStaticCacheableResource {
    private static final Logger log = LoggerFactory.getLogger(ConcatBundleResource.class);
    private static final long serialVersionUID = 1L;
    private final List<? extends IReferenceHeaderItem> providedResources;
    private boolean cachingEnabled;
    private ITextResourceCompressor compressor;

    public ConcatBundleResource(List<? extends IReferenceHeaderItem> providedResources) {
        this.providedResources = (List)Args.notNull(providedResources, (String)"providedResources");
        this.cachingEnabled = true;
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        if (resourceResponse.dataNeedsToBeWritten(attributes)) {
            try {
                List<IResourceStream> resources = this.collectResourceStreams();
                if (resources == null) {
                    return this.sendResourceError(resourceResponse, 404, "Unable to find resource");
                }
                resourceResponse.setContentType(this.findContentType(resources));
                Time lastModified = this.findLastModified(resources);
                if (lastModified != null) {
                    resourceResponse.setLastModified(lastModified);
                }
                final byte[] bytes = this.readAllResources(resources);
                resourceResponse.setContentLength(bytes.length);
                resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                    @Override
                    public void writeData(IResource.Attributes attributes) {
                        attributes.getResponse().write(bytes);
                    }
                });
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
                return this.sendResourceError(resourceResponse, 500, "Unable to read resource stream");
            }
            catch (ResourceStreamNotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
                return this.sendResourceError(resourceResponse, 500, "Unable to open resource stream");
            }
        }
        return resourceResponse;
    }

    private List<IResourceStream> collectResourceStreams() {
        ArrayList<IResourceStream> ret = new ArrayList<IResourceStream>(this.providedResources.size());
        for (IReferenceHeaderItem iReferenceHeaderItem : this.providedResources) {
            IResourceStream stream = ((IStaticCacheableResource)iReferenceHeaderItem.getReference().getResource()).getResourceStream();
            if (stream == null) {
                this.reportError(iReferenceHeaderItem.getReference(), "Cannot get resource stream for ");
                return null;
            }
            ret.add(stream);
        }
        return ret;
    }

    protected String findContentType(List<IResourceStream> resources) {
        for (IResourceStream curStream : resources) {
            if (curStream.getContentType() == null) continue;
            return curStream.getContentType();
        }
        return null;
    }

    protected Time findLastModified(List<IResourceStream> resources) {
        Time ret = null;
        for (IResourceStream curStream : resources) {
            Time curLastModified = curStream.lastModifiedTime();
            if (ret != null && !curLastModified.after((AbstractTimeValue)ret)) continue;
            ret = curLastModified;
        }
        return ret;
    }

    protected byte[] readAllResources(List<IResourceStream> resources) throws IOException, ResourceStreamNotFoundException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (IResourceStream curStream : resources) {
            IOUtils.copy((InputStream)curStream.getInputStream(), (OutputStream)output);
        }
        byte[] bytes = output.toByteArray();
        ITextResourceCompressor textResourceCompressor = this.getCompressor();
        if (textResourceCompressor != null) {
            String nonCompressed = new String(bytes, "UTF-8");
            if (textResourceCompressor instanceof IScopeAwareTextResourceProcessor) {
                ResourceReference reference = this.providedResources.get(0).getReference();
                Class<?> scope = reference.getScope();
                String name = reference.getName();
                bytes = ((IScopeAwareTextResourceProcessor)textResourceCompressor).process(nonCompressed, scope, name).getBytes("UTF-8");
            } else {
                bytes = textResourceCompressor.compress(nonCompressed).getBytes("UTF-8");
            }
        }
        return bytes;
    }

    private AbstractResource.ResourceResponse sendResourceError(AbstractResource.ResourceResponse resourceResponse, int errorCode, String errorMessage) {
        if (log.isWarnEnabled()) {
            String msg = String.format("Bundled resource: %s (status=%d)", errorMessage, errorCode);
            log.warn(msg);
        }
        resourceResponse.setError(errorCode, errorMessage);
        return resourceResponse;
    }

    @Override
    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean enabled) {
        this.cachingEnabled = enabled;
    }

    @Override
    public Serializable getCacheKey() {
        ArrayList<Serializable> key = new ArrayList<Serializable>(this.providedResources.size());
        for (IReferenceHeaderItem iReferenceHeaderItem : this.providedResources) {
            Serializable curKey = ((IStaticCacheableResource)iReferenceHeaderItem.getReference().getResource()).getCacheKey();
            if (curKey == null) {
                this.reportError(iReferenceHeaderItem.getReference(), "Unable to get cache key for ");
                return null;
            }
            key.add(curKey);
        }
        return key;
    }

    private void reportError(ResourceReference reference, String prefix) {
        String scope = Classes.name(reference.getScope());
        String name = reference.getName();
        String message = prefix + reference.toString();
        if (this.getThrowExceptionOnMissingResource()) {
            throw new MissingResourceException(message, scope, name);
        }
        if (log.isWarnEnabled()) {
            log.warn(message);
        }
    }

    @Override
    public IResourceStream getResourceStream() {
        byte[] bytes;
        List<IResourceStream> resources = this.collectResourceStreams();
        if (resources == null) {
            return null;
        }
        try {
            bytes = this.readAllResources(resources);
        }
        catch (IOException e) {
            return null;
        }
        catch (ResourceStreamNotFoundException e) {
            return null;
        }
        final String contentType = this.findContentType(resources);
        final Time lastModified = this.findLastModified(resources);
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        final long length = bytes.length;
        AbstractResourceStream ret = new AbstractResourceStream(){
            private static final long serialVersionUID = 1L;

            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                return inputStream;
            }

            public Bytes length() {
                return Bytes.bytes((long)length);
            }

            public String getContentType() {
                return contentType;
            }

            public Time lastModifiedTime() {
                return lastModified;
            }

            public void close() throws IOException {
                inputStream.close();
            }
        };
        return ret;
    }

    public void setCompressor(ITextResourceCompressor compressor) {
        this.compressor = compressor;
    }

    public ITextResourceCompressor getCompressor() {
        return this.compressor;
    }

    protected boolean getThrowExceptionOnMissingResource() {
        return Application.get().getResourceSettings().getThrowExceptionOnMissingResource();
    }
}

