/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.atmosphere.AtmosphereInternalEvent;
import org.apache.wicket.atmosphere.EventBus;
import org.apache.wicket.atmosphere.JQueryWicketAtmosphereResourceReference;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.CoreLibrariesContributor;
import org.apache.wicket.util.string.Strings;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.Meteor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereBehavior
extends AbstractAjaxBehavior
implements AtmosphereResourceEventListener {
    private static final Logger log = LoggerFactory.getLogger(AtmosphereBehavior.class);
    public static final MetaDataKey<String> ATMOSPHERE_UUID = new MetaDataKey<String>(){
        private static final long serialVersionUID = 1L;
    };
    private static final long serialVersionUID = 1L;
    private String applicationKey = Application.get().getApplicationKey();

    private EventBus findEventBus() {
        return EventBus.get(Application.get((String)this.applicationKey));
    }

    public final boolean getStatelessHint(Component component) {
        return false;
    }

    public void onPreSuspend(AtmosphereResourceEvent event) {
    }

    public void onClose(AtmosphereResourceEvent event) {
    }

    public void onRequest() {
        RequestCycle requestCycle = RequestCycle.get();
        ServletWebRequest request = (ServletWebRequest)requestCycle.getRequest();
        Meteor meteor = Meteor.build((HttpServletRequest)request.getContainerRequest());
        meteor.addListener((AtmosphereResourceEventListener)this);
        meteor.suspend(-1L);
        String uuid = meteor.getAtmosphereResource().uuid();
        Page page = this.getComponent().getPage();
        page.setMetaData(ATMOSPHERE_UUID, (Serializable)((Object)uuid));
        this.findEventBus().registerPage(uuid, page);
    }

    public void onBroadcast(AtmosphereResourceEvent event) {
        EventBus eventBus;
        String transport;
        if (log.isDebugEnabled()) {
            log.debug("onBroadcast: {}", event.getMessage());
        }
        if ("long-polling".equalsIgnoreCase(transport = event.getResource().getRequest().getHeader("X-Atmosphere-Transport"))) {
            Meteor meteor = Meteor.lookup((HttpServletRequest)event.getResource().getRequest());
            meteor.resume();
        }
        if ((eventBus = this.findEventBus()).isWantAtmosphereNotifications()) {
            eventBus.post(new AtmosphereInternalEvent(AtmosphereInternalEvent.Type.Broadcast, event));
        }
    }

    public void onSuspend(AtmosphereResourceEvent event) {
        if (log.isDebugEnabled()) {
            AtmosphereRequest atmosphereRequest = event.getResource().getRequest();
            String transport = atmosphereRequest.getHeader("X-Atmosphere-Transport");
            log.debug(String.format("Suspending the %s response from ip %s:%s", transport == null ? "websocket" : transport, atmosphereRequest.getRemoteAddr(), atmosphereRequest.getRemotePort()));
        }
    }

    public void onResume(AtmosphereResourceEvent event) {
        EventBus eventBus;
        if (log.isDebugEnabled()) {
            AtmosphereRequest atmosphereRequest = event.getResource().getRequest();
            String transport = atmosphereRequest.getHeader("X-Atmosphere-Transport");
            log.debug(String.format("Resuming the %s response from ip %s:%s", transport == null ? "websocket" : transport, atmosphereRequest.getRemoteAddr(), atmosphereRequest.getRemotePort()));
        }
        if ((eventBus = this.findEventBus()).isWantAtmosphereNotifications()) {
            eventBus.post(new AtmosphereInternalEvent(AtmosphereInternalEvent.Type.Resume, event));
        }
    }

    public void onDisconnect(AtmosphereResourceEvent event) {
        if (log.isDebugEnabled()) {
            AtmosphereRequest atmosphereRequest = event.getResource().getRequest();
            String transport = atmosphereRequest.getHeader("X-Atmosphere-Transport");
            log.debug(String.format("%s connection dropped from ip %s:%s", transport == null ? "websocket" : transport, atmosphereRequest.getRemoteAddr(), atmosphereRequest.getRemotePort()));
        }
        EventBus eventBus = this.findEventBus();
        if (Application.get((String)this.applicationKey) != null) {
            eventBus.unregisterConnection(event.getResource().uuid());
        }
        if (eventBus.isWantAtmosphereNotifications()) {
            eventBus.post(new AtmosphereInternalEvent(AtmosphereInternalEvent.Type.Disconnect, event));
        }
    }

    public void onThrowable(AtmosphereResourceEvent event) {
        Throwable throwable = event.throwable();
        log.error(throwable.getMessage(), throwable);
        EventBus eventBus = this.findEventBus();
        if (eventBus.isWantAtmosphereNotifications()) {
            eventBus.post(new AtmosphereInternalEvent(AtmosphereInternalEvent.Type.Throwable, event));
        }
    }

    public void onHeartbeat(AtmosphereResourceEvent event) {
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        try {
            CoreLibrariesContributor.contributeAjax((Application)component.getApplication(), (IHeaderResponse)response);
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JQueryWicketAtmosphereResourceReference.get()));
            JSONObject options = this.findEventBus().getParameters().toJSON();
            options.put("url", (Object)this.getCallbackUrl());
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("jQuery('#" + component.getMarkupId() + "').wicketAtmosphere(" + options.toString() + ")")));
        }
        catch (JSONException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public CharSequence getCallbackUrl() {
        RequestCycle requestCycle = this.getComponent().getRequestCycle();
        Url baseUrl = requestCycle.getUrlRenderer().getBaseUrl();
        CharSequence ajaxBaseUrl = Strings.escapeMarkup((CharSequence)baseUrl.toString());
        return new StringBuilder(256).append(super.getCallbackUrl()).append('&').append("wicket-ajax").append("=true&").append("wicket-ajax-baseurl").append('=').append(ajaxBaseUrl);
    }

    public static String getUUID(Page page) {
        return (String)((Object)page.getMetaData(ATMOSPHERE_UUID));
    }

    @Deprecated
    public static String getUUID(AtmosphereResource resource) {
        return resource.uuid();
    }
}

