/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.stateless;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.application.IComponentOnBeforeRenderListener;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.devutils.stateless.StatelessCheckFailureException;
import org.apache.wicket.devutils.stateless.StatelessComponent;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.StringList;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

public class StatelessChecker
implements IComponentOnBeforeRenderListener {
    protected boolean mustCheck(Component component) {
        StatelessComponent ann = component.getClass().getAnnotation(StatelessComponent.class);
        return ann != null && ann.enabled();
    }

    protected void fail(StatelessCheckFailureException e) {
        throw e;
    }

    public void onBeforeRender(final Component component) {
        if (this.mustCheck(component)) {
            MarkupContainer container;
            Object o;
            IVisitor<Component, Component> visitor = new IVisitor<Component, Component>(){

                public void component(Component comp, IVisit<Component> visit) {
                    if (component instanceof Page && StatelessChecker.this.mustCheck(comp)) {
                        visit.dontGoDeeper();
                    } else if (!comp.isStateless()) {
                        visit.stop((Object)comp);
                    }
                }
            };
            if (!component.isStateless()) {
                StringList statefulBehaviors = new StringList();
                for (Behavior b : component.getBehaviors()) {
                    if (b.getStatelessHint(component)) continue;
                    statefulBehaviors.add(Classes.name(b.getClass()));
                }
                String reason = statefulBehaviors.size() == 0 ? " Possible reason: no stateless hint" : " Stateful behaviors: " + statefulBehaviors.join();
                this.fail(new StatelessCheckFailureException(component, reason));
                return;
            }
            if (component instanceof MarkupContainer && (o = (container = (MarkupContainer)component).visitChildren((IVisitor)visitor)) != null) {
                this.fail(new StatelessCheckFailureException((Component)container, " Offending component: " + o));
                return;
            }
            if (component instanceof Page) {
                Page p = (Page)component;
                if (!p.isBookmarkable()) {
                    this.fail(new StatelessCheckFailureException((Component)p, " Only bookmarkable pages can be stateless"));
                    return;
                }
                if (!p.isPageStateless()) {
                    this.fail(new StatelessCheckFailureException((Component)p, " for unknown reason"));
                    return;
                }
            }
        }
    }
}

